# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          dadml
Version:       1.4
Release:       alt1_8
Summary:       Database Access Definition Markup Language
Group:         Development/Java
License:       GPL
Url:           http://sourceforge.net/projects/woc/
# cvs -d:pserver:anonymous@woc.cvs.sourceforge.net:/cvsroot/woc login
# cvs -z3 -d:pserver:anonymous@woc.cvs.sourceforge.net:/cvsroot/woc co -P dadml
# tar czf dadml-1.4-src-cvs.tar.gz dadml
Source0:       dadml-1.4-src-cvs.tar.gz
Source1:       dadml-1.4.pom
BuildRequires: java-devel-default /proc
BuildRequires: ant
BuildRequires: javapackages-tools
BuildRequires: xerces-j2
Requires:      javapackages-tools
Requires:      xerces-j2
BuildArch:     noarch
Source44: import.info

%description
DAD ML's reason for existence is making databases accessible.
However, this can be divided in three parts. One is a database
definition, a second is a content index and the third is being a
list of DAD compliant databases.
The first type of information makes an database accessible. It
provides information on the types of information that can be found
in this database. More specific it defines the fields of the database.
This information is contained in the tag <DBDEF>.
The second type provides a way of making the database searchable. At
defines which records are available in this database. The index
should be a unique ID. For chemical compounds this could be CAS numbers.
This information is contained in the tag <DBDATA>.
This indexed data file might also provide a conversion from the
unique ID to an ID used by this database. Database therefore need
not be searchable by this unique ID.
The last type provides means by which one can build a superdatabase.
This superdatabase is able to access other databases. Making this database
searchable makes also all other databases searchable if they provided a
index list. This information is contained in the tag <DBLIST>.

%package javadoc
Group:         Documentation
Summary:       Javadoc for %{name}
Requires:      %{name} = %{?epoch:%epoch:}%{version}-%{release}
Requires:      javapackages-tools
BuildArch: noarch

%description javadoc
DADML - Database Access Definition Markup Language.

This package contains javadoc for %{name}.

%prep
%setup -q -n dadml

for j in $(find . -name "*.jar"); do
   	mv $j $j.no
done

for j in $(find . -name "CVS"); do
   	rm -rf $j
done

for i in "CHANGELOG.TXT LICENSE.TXT README.TXT" ; do
	sed -i 's/\r//' $i
done

ln -sf $(build-classpath xerces-j2) jar/xerces-2.5.0.jar

%build
ant jar doc

%install
mkdir -p %{buildroot}%{_javadir}
install -pm 644 dadml.jar %{buildroot}%{_javadir}/dadml-%{version}.jar

(
	cd %{buildroot}%{_javadir}
	for jar in *-%{version}*; do
		ln -sf ${jar} `echo $jar| sed "s|-%{version}||g"`
	done
)

mkdir -p %{buildroot}%{_javadocdir}/dadml-%{version}
cp -pr api/* %{buildroot}%{_javadocdir}/dadml-%{version}
ln -sf dadml-%{version} %{buildroot}%{_javadocdir}/dadml

%files
%{_javadir}/dadml-%{version}.jar
%{_javadir}/dadml.jar
%doc CHANGELOG.TXT LICENSE.TXT README.TXT

%files javadoc
%{_javadocdir}/dadml-%{version}
%{_javadocdir}/dadml



%changelog
