Group: Networking/WWW
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: daemonize
Version: 1.7.8
Release: alt1_13
Summary: Run a command as a Unix daemon
License: BSD-3-Clause AND MIT AND FSFUL
URL: http://www.clapper.org/software/daemonize/
Source: https://github.com/bmc/%{name}/archive/release-%{version}/%{name}-%{version}.tar.gz

# Fix for getopt.c too many args errors in gcc-15
# https://github.com/bmc/daemonize/commit/eaf4746d47e171e7b8655690eb1e91fc216f2866
Patch0: 0001-fix-getopt.c-too-many-arguments-to-function-write-er.patch

BuildRequires:  gcc
Source44: import.info
%description
daemonize runs a command as a Unix daemon. As defined in W. Richard Stevens' 
1990 book, Unix Network Programming (Addison-Wesley, 1990), a daemon is "a 
process that executes 'in the background' (i.e., without an associated 
terminal or login shell) either waiting for some event to occur, or waiting 
to perform some specified task on a periodic basis." Upon startup, a typical 
daemon program will:

- Close all open file descriptors (especially standard input, standard output 
  and standard error)
- Change its working directory to the root filesystem, to ensure that it 
  doesna.'t tie up another filesystem and prevent it from being unmounted
- Reset its umask value
- Run in the background (i.e., fork)
- Disassociate from its process group (usually a shell), to insulate itself 
  from signals (such as HUP) sent to the process group
- Ignore all terminal I/O signals
- Disassociate from the control terminal (and take steps not to reacquire one)
- Handle any SIGCLD signals

Most programs that are designed to be run as daemons do that work for 
themselves. However, youa.'ll occasionally run across one that does not. 
When you must run a daemon program that does not properly make itself into a 
true Unix daemon, you can use daemonize to force it to run as a true daemon.

%prep
%setup -q -n %{name}-release-%{version}
%patch0 -p1


%build
%configure
%make_build

%install
make DESTDIR=%{buildroot} INSTALL="install -p" INSTALL_SBIN=%{_sbindir} install

%files
%doc --no-dereference LICENSE.md
%doc CHANGELOG.md README.md
%{_sbindir}/daemonize
%{_mandir}/man1/daemonize.1*

%changelog
