Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate gcc-c++ libX11-devel pkgconfig(bzip2) pkgconfig(expat) pkgconfig(libbrotlidec) pkgconfig(libpcre) pkgconfig(libpng) pkgconfig(uuid) pkgconfig(zlib)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global icondir %{_datadir}/icons/hicolor
%global reponame danmaQ

Name:		danmaq
Version:	0.2.3.2
Release:	alt1_6
Summary:	A small client side Qt program to play danmaku on any screen

License:	GPLv3
URL:		https://github.com/TUNA/%{reponame}
Source0:        %{url}/archive/v%{version}/%{reponame}-v%{version}.tar.gz

BuildRequires:	qt5-x11extras-devel
BuildRequires:	qt5-base-devel
BuildRequires:  qt5-designer qt5-tools
BuildRequires:	ctest cmake
BuildRequires:	desktop-file-utils
BuildRequires:  libXext-devel
Source44: import.info

%description
DanmaQ is a small client side Qt program to play danmaku on any screen.

%prep
%setup -q -n %{reponame}-%{version}
sed -i s,Qt5::lrelease,lrelease-qt5, src/translations/CMakeLists.txt

%build
mkdir build && cd build
%{fedora_v2_cmake3} ..
# Since 0.2.3 it cannot be built in parallel. So use make instead of macro.
%fedora_v2_cmake_build

%install
# install 
pushd build
%fedora_v2_cmake_install
#install -Dm 0755 build/src/%{reponame} %{buildroot}%{_bindir}/%{reponame}
popd

# icon files
install -Dm0644 src/icons/statusicon.ico    %{buildroot}%{_datadir}/pixmaps/statusicon.ico
install -Dm0644 src/icons/statusicon.png    %{buildroot}%{_datadir}/pixmaps/statusicon.png
install -Dm0644 src/icons/statusicon_disabled.png    %{buildroot}%{_datadir}/pixmaps/statusicon_disabled.png
install -Dm0644 src/icons/statusicon.svg %{buildroot}%{icondir}/scalable/apps/statusicon.svg
install -Dm0644 src/resource/danmaQ.desktop %{buildroot}%{_datadir}/applications/%{reponame}.desktop
install -Dm0644 src/resource/danmaQ.png    %{buildroot}%{_datadir}/pixmaps/danmaQ.png
install -Dm0644 src/resource/danmaQ.svg %{buildroot}%{icondir}/scalable/apps/danmaQ.svg


%check
desktop-file-validate %{buildroot}%{_datadir}/applications/%{reponame}.desktop

%files
%doc README.md
%doc --no-dereference LICENSE
%{_bindir}/%{reponame}
%{_mandir}/man1/%{reponame}.1*
%{_datadir}/pixmaps/*
%{_datadir}/icons/hicolor/*/apps/*
%{_datadir}/applications/%{reponame}.desktop

%changelog
