Group: System/Libraries
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}

# fedora package review: http://bugzilla.redhat.com/429760

%define qt3pkg qt
%if 0%{?fedora} > 8
%define qt3pkg qt3
%endif

Name:    dbus-qt3
Summary: Qt3 DBus Bindings
Version: 0.9
Release: alt2_39

# Automatically converted from old format: GPLv2+ - review is highly recommended.
License: GPL-2.0-or-later
Url:     http://www.freedesktop.org/wiki/Software/DBusBindings
Source0: http://people.freedesktop.org/~krake/dbus-1-qt3/dbus-1-qt3-%{version}.tar.gz

Patch0:  dbus-1-qt3-0.9-libtool-aarch64.patch
Patch1:  dbus-qt3-configure-c99.patch

BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires: libdbus-devel
BuildRequires: libqt3-devel

Provides: dbus-1-qt3 = %{version}-%{release}
Source44: import.info

%description
This library provides Qt3-classes for accessing the DBus.

%package devel
Group: Development/Other
Summary: Development files for %{name} 
Provides: dbus-1-qt3-devel = %{version}-%{release}
Requires: %{name} = %{version}-%{release}
Requires: pkgconfig
%description devel
%{summary}.


%prep
%setup -q -n dbus-1-qt3-%{version}
%patch0  -p1 -b .libtool-aarch64
%patch1  -p1 -b .configure-c99


%build


%configure \
  --disable-static \
  --disable-warnings

%make_build


%install

make install DESTDIR=$RPM_BUILD_ROOT

# unpackaged files
rm -f $RPM_BUILD_ROOT%{_libdir}/lib*.la






%files
%doc README AUTHORS ChangeLog COPYING
%{_libdir}/lib*.so.*

%files devel
%{_bindir}/dbusxml2qt3
%{_libdir}/lib*.so
%{_includedir}/dbus-1.0/qt3/
%{_libdir}/pkgconfig/dbus-1-qt3.pc


%changelog
