Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: DHCP relay agent
Name: dhcp-forwarder
Version: 0.11
Release: alt2_25
# Automatically converted from old format: GPLv3 - review is highly recommended.
License: GPL-3.0-only
URL: http://www.nongnu.org/dhcp-fwd/
Source0: http://savannah.nongnu.org/download/dhcp-fwd/%name-%version.tar.xz
Source1: http://savannah.nongnu.org/download/dhcp-fwd/%name-%version.tar.xz.asc
Source2: dhcp-forwarder.service

BuildRequires:  gcc
Requires(post): coreutils bash sh

# required to update the old packages which had init system sub packages
Obsoletes: dhcp-forwarder-systemd
Source44: import.info

%description
dhcp-fwd forwards DHCP messages between subnets with different sublayer
broadcast domains. It is similar to the DHCP relay agent dhcrelay of
ISC's DHCP, but has the following important features:

* Runs as non-root in a chroot-environment
* Uses AF_INET sockets which makes it possible to filter incoming
  messages with packetfilters
* The DHCP agent IDs can be defined freely
* Has a small memory footprint when using dietlibc

%prep
%setup -q

# Create a sysusers.d config file
cat >dhcp-forwarder.sysusers.conf <<EOF
u dhcp-fwd - 'DHCP Forwarder user' %{_sharedstatedir}/dhcp-fwd -
EOF

%build
%configure \
 --enable-release \
 --with-systemd-unitdir=%_unitdir \
 --disable-dietlibc

%make_build

%install

install -d %{buildroot}/%{_sharedstatedir}/dhcp-fwd \
 %{buildroot}/%{_unitdir} %{buildroot}/%{_sysconfdir}
make DESTDIR=%{buildroot} install
install %{SOURCE2} %{buildroot}/%{_unitdir}/dhcp-forwarder.service
install contrib/dhcp-fwd.conf %{buildroot}/%{_sysconfdir}

install -m0644 -D dhcp-forwarder.sysusers.conf %{buildroot}%{_sysusersdir}/dhcp-forwarder.conf

%check
make check


%files
%doc AUTHORS COPYING ChangeLog NEWS README
%dir %attr(0755,root,root) %{_sharedstatedir}/dhcp-fwd
%_sbindir/*
%_mandir/*/*
%attr(0644,root,root) %{_unitdir}/dhcp-forwarder.service
%attr(0755,root,root) %config(noreplace) %{_sysconfdir}/dhcp-fwd.conf
%{_sysusersdir}/dhcp-forwarder.conf

%post
%post_service dhcp-forwarder

%preun
%preun_service dhcp-forwarder

%changelog
