Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: texinfo
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name dibbler
%global common_desc \
Dibbler is a portable DHCPv6 implementation. It supports stateful (i.e. IPv6 \
address granting and IPv6 prefix delegation) as well as stateless (i.e. option \
granting) autoconfiguration for IPv6.

%if 0%{?rhel} < 7 && 0%{?rhel} > 0
%global _pkgdocdir %{_docdir}/%{name}
%endif

Name:		dibbler
Version:	1.0.1
Release:	alt1_10
Summary:	Portable DHCPv6 implementation

License:	GPLv2
URL:		http://klub.com.pl/dhcpv6
Source0:	http://klub.com.pl/dhcpv6/dibbler/dibbler-%{version}.tar.gz

BuildRequires:  gcc-c++
Source44: import.info
%description
%{common_desc}


%package client
Group: Other
Summary:	Dibbler, DHCPv6 client


%description client
%{common_desc}

This package contains DHCPv6 client.


%package relay
Group: Other
Summary:	Dibbler, DHCPv6 relay


%description relay
%{common_desc}

This package contains DHCPv6 relay.


%package requestor
Group: Other
Summary:	Dibbler, DHCPv6 request generator


%description requestor
%{common_desc}

This package contains DHCPv6 request generator.


%package server
Group: Other
Summary:	Dibbler, DHCPv6 server


%description server
%{common_desc}

This package contains DHCPv6 server.


%package docs
Group: Other
Summary:	Dibbler documentation
BuildArch:	noarch


%description docs
%{common_desc}

This package contains dibbler documentation.


%prep
%setup -q -n dibbler-%{version}


%build
%configure
%make_build


%install
make install DESTDIR=%{buildroot}

# We explicitly add license file to each sub-package, so no need to install it
# as documentation
rm %{buildroot}%{_docdir}/%{name}/LICENSE

# Setup directories
install -p -d -m 755 %{buildroot}%{_sharedstatedir}/dibbler
install -p -d -m 755 %{buildroot}%{_sysconfdir}/dibbler

# Install configuration files
for config in client relay server; do
    cp -p doc/examples/$config.conf %{buildroot}%{_sysconfdir}/dibbler
done

# Kill example files irrelevant to Fedora Linux
for file in client-win32.conf server-win32.conf; do
    rm %{buildroot}%{_docdir}/%{name}/examples/$file
done

for file in client-notify-bsd.sh client-notify-macos.sh; do
    rm %{buildroot}%{_docdir}/%{name}/scripts/notify-scripts/$file
done


%files client
%doc --no-dereference LICENSE
%{_sbindir}/dibbler-client
%{_mandir}/man8/dibbler-client.8*
%dir %{_sysconfdir}/dibbler
%config(noreplace) %{_sysconfdir}/dibbler/client.conf
%dir %{_sharedstatedir}/dibbler


%files relay
%doc --no-dereference LICENSE
%{_sbindir}/dibbler-relay
%{_mandir}/man8/dibbler-relay.8*
%dir %{_sysconfdir}/dibbler
%config(noreplace) %{_sysconfdir}/dibbler/relay.conf
%dir %{_sharedstatedir}/dibbler


%files requestor
%doc --no-dereference LICENSE
%{_sbindir}/dibbler-requestor
%dir %{_sharedstatedir}/dibbler


%files server
%doc --no-dereference LICENSE
%{_sbindir}/dibbler-server
%{_mandir}/man8/dibbler-server.8*
%dir %{_sysconfdir}/dibbler
%config(noreplace) %{_sysconfdir}/dibbler/server.conf
%dir %{_sharedstatedir}/dibbler


%files docs
%doc --no-dereference LICENSE
%dir %{_docdir}/%{name}
%{_docdir}/%{name}/CHANGELOG
%{_docdir}/%{name}/RELNOTES
%{_docdir}/%{name}/dibbler-user.pdf
%dir %{_docdir}/%{name}/examples
%dir %{_docdir}/%{name}/scripts
%{_docdir}/%{name}/examples/*.conf
%{_docdir}/%{name}/scripts/*


%changelog
