# BEGIN SourceDeps(oneline):
BuildRequires: tex(dehypht.tex) texlive-dist
# END SourceDeps(oneline)
Group: Development/Tools
BuildRequires: /usr/bin/ps2pdf tex(dvips.def)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:        Random number generator tester and timer
Name:           dieharder
Version:        3.31.1
Release:        alt2_32
License:        GPLv2+
Source0:        http://www.phy.duke.edu/~rgb/General/%{name}/%{name}-%{version}.tgz
URL:            http://www.phy.duke.edu/~rgb/General/dieharder.php
Patch0:         dieharder-3.31.1_urandom_64bit.patch 
Patch1:         dieharder-3.31.1_aarch64.patch
Patch2:         dieharder-3.31.1_BZ1100855.patch

Requires:       %{name}-libs = %{version}-%{release}

BuildRequires:  gcc
# Needed for building manual
BuildRequires:  texlive texlive-collection-basic
BuildRequires:  latex2html

BuildRequires:  libgsl-devel

%add_optflags -fcommon
Source44: import.info

%description 
dieharder is a fairly involved random number/uniform deviate generator
tester.  It can either test any of its many pre-built and linked
generators (basically all of those in the Gnu Scientific Library plus
some others) or a potentially random data-set in a file.  With file
input, it can manage either a variety of ASCII-formatted input or a raw
binary bit string.  It is thus suitable for use in testing both software
RNG's and hardware RNG's.

dieharder does all of its work with a standalone, extensible library,
libdieharder. Therefore its tests can be integrated into other programs.

dieharder encapsulates following random number tests: George Marsaglia's
"Diehard" battery of tests, STS (v1.6) from NIST FIPS, Knuth's tests,
and more.  Check the documentation for complete list of the tests and
references where possible. It is intended to be the "Swiss army knife of
random number testers", or "the last suite of random number testers
you'll ever wear".

########################################################################
# LIBRARY: This is the basic dieharder library
########################################################################

%package libs
Group: Development/Other
Summary:        A library of random number generator tests and timing routines

%description libs

libdieharder is the core library of dieharder designed to be "the last
suite of random number testers you'll ever wear".  It can test any of
its many pre-built and library linked generators (basically all of those
in the Gnu Scientific Library plus a number of others from various
sources) or a potentially random data-set in either an ASCII-formatted
or raw (presumed 32 bit unsigned int) binary file.  It is fairly
straightforward to wrap new software generators for testing, or to add
hardware generators that have a software interface for testing, and the
file input method permits pretty much any software or hardware RNG to be
tested using libdieharder calls.

libdieharder has as a design goal the full encapsulation in an
extensible shell of basically all the random number tests: George
Marsaglia's "Diehard" battery of tests, STS (v1.6) from NIST FIPS,
Knuth's tests, and more.  Check the documentation for complete list.  


%package devel
Group: Development/Other
Summary: A library of random number generator tests and timing routines
Requires:  %{name} = %{version}-%{release}

%description devel
Development files for %{name}


########################################################################
# The main section common to all builds.
########################################################################
%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1

%build
%configure
###SMP build is not working
###make %{?_smp_mflags} V=1
make V=1

# Build pdf manual
pushd manual
make


%check
make check


%install
make install DESTDIR=%{buildroot} INSTALL="install -p"
rm -rf %{buildroot}%{_libdir}/libdieharder.la
rm -rf %{buildroot}%{_libdir}/libdieharder.a

mkdir -p %{buildroot}%{_defaultdocdir}/%{name}
cp -p ChangeLog Copyright README COPYING NOTES %{name}.html manual/%{name}.pdf %{buildroot}%{_defaultdocdir}/%{name}


########################################################################
# Command to execute post install or uninstall of libdieharder
########################################################################


########################################################################
# Files installed with the dieharder tty UI
########################################################################
%files
%{_bindir}/%{name}
%{_mandir}/man1/%{name}*
%{_defaultdocdir}/*

%files libs
%{_libdir}/*.so.*
%{_mandir}/man3/lib%{name}.*

%files devel
%{_includedir}/%{name}
%{_libdir}/*.so

%changelog
