Group: Text tools
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       diffmark
Version:    0.10
Release:    alt2_32
Summary:    XML diff and merge
# COPYING:          diffmark license text
# lib/lcs.hh:       GPL+ or Artistic    (based on Algorithm-Diff)
# lib/xutil.hh:     GPL+ or Artistic    (based on XML-LibXML dom.c)
## Not in any binary package
# aclocal.m4:       FSFUL and FSFULLR and GPLv2+ with a Libtool exception and
#                   and GPLv2+ with an Autoconf exception
# cmd/Makefile.in:  FSFUL
# config.guess:     GPLv2+ with an Autoconf exception
# config.sub:       GPLv2+ with an Autoconf exception
# configure:        FSFUL and GPLv2+ with a Libtool exception
# depcomp:          GPLv2+ with an Autoconf exception
# diffmark.test/Makefile.in:        FSFULLR
# doc/Makefile.in:  FSFULLR
# install-sh:       MIT
# lib/Makefile.in:  FSFULLR
# ltmain.sh:        GPLv2+ with a Libtool exception
# Makefile.in:      FSFULLR
# missing:          GPLv2+ with an Autoconf exception
# testdata/diff/Makefile.in:        FSFULLR
# testdata/faildiff/Makefile.in:    FSFULLR
# testdata/failmerge/Makefile.in:   FSFULLR
# testdata/Makefile.in:             FSFULLR
# testdata/merge/Makefile.in:       FSFULLR
# testdata/roundup/Makefile.in:     FSFULLR
License:    diffmark and (GPL+ or Artistic)
URL:        http://www.mangrove.cz/%{name}/
Source0:    http://www.mangrove.cz/%{name}/%{name}-%{version}.tar.gz
# Remove a superfluous RPATH from the programs
Patch0:     %{name}-0.09-remove_rpath.patch
# Adjust to GCC 11 that defaults to -std=gnu++17 that forbirds non-const
# comparison objects
Patch1:     %{name}-gcc11.patch
# Because of diffmark-0.08-remove_rpath.patch:
# And to update config.sub to support aarch64, bug #925255
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  findutils
BuildRequires:  gcc-c++
BuildRequires:  libtool
BuildRequires:  libxml2-devel
Source44: import.info

%description
This is an XML diff and merge package. It consists of a shared library and
two utilities: dm and dm-merge. 

%package        devel
Group: Development/Other
Summary:        Development files for %{name} library
Requires:       %{name} = %{version}-%{release}

%description    devel
Header files and libraries for developing applications that use %{name}.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
# automake -i -f to support aarch64, bug #925255
libtoolize --force && autoreconf -i -f

%build
%configure --enable-shared --disable-static
%{make_build}

%install
%{makeinstall_std}
find "$RPM_BUILD_ROOT" -name '*.la' -delete

%files
%doc --no-dereference COPYING
%doc doc/*.html README
%{_bindir}/*
%{_libdir}/*.so.*

%files devel
%{_includedir}/*
%{_libdir}/*.so

%changelog
