# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install libICE-devel libSM-devel libX11-devel perl-base texinfo
# END SourceDeps(oneline)
%define fedora 23
# Features in Fedora/Free Electronic Lab
#   Supported targets: EL-5, EL-6, F-15, F-16 and rawhide

# If the emacs-el package has installed a pkgconfig file, use that to determine
# install locations and Emacs version at build time, otherwise set defaults.
%if %($(pkg-config emacs) ; echo $?)
%define emacs_version  21.0
%define emacs_lispdir  %{_datadir}/emacs/site-lisp
%define emacs_startdir %{_datadir}/emacs/site-lisp/site-start.d
%else
%define emacs_version  %{expand:%(pkg-config emacs --modversion)}
%define emacs_lispdir  %{expand:%(pkg-config emacs --variable sitepkglispdir)}
%define emacs_startdir %{expand:%(pkg-config emacs --variable sitestartdir)}
%endif

Name:           dinotrace
Version:        9.4c
Release:        alt1_10
Summary:        Waveform viewer for electronics

URL:            http://www.veripool.org/wiki/dinotrace
Source0:        http://www.veripool.com/ftp/%{name}-%{version}.tgz

License:        GPLv3+
Group:          Engineering

%if 0%{?fedora} >= 24
BuildRequires:  motif-devel
%else if 0%{?fedora}
BuildRequires:  lesstif-devel
%else
BuildRequires:  openmotif-devel
%endif

BuildRequires:  desktop-file-utils

# menu entry compliance with Fedora Electronic Lab menu structure

# desktop entry icon
Requires:       gnome-icon-theme
Source44: import.info


%description
Dinotrace is a waveform viewer which understands Verilog Value
Change Dumps, ASCII, and other trace formats. It allows placing
cursors, highlighting signals, searching, printing, and other
capabilities superior to many commercial waveform viewers.

Dinotrace is optimized for rapid debugging. With VTRACE, a simulation
failure will automatically place cursors where errors occur, add
comments visible in the wave form viewer. Four mouse clicks and the
errors will be highlighted in the log files, and the values of signals
at the error will be seen in the source.


%package -n        emacs-%{name}
Summary:           Elisp source files for %{name} under GNU Emacs
Group:             Development/C
BuildRequires:     emacs-el
BuildRequires:     emacs
Requires:          emacs >= %{emacs_version}
Requires:          %{name} = %{version}
%if 0%{?rhel}
BuildRequires:     emacs-verilog-mode
Requires:          emacs-verilog-mode
%endif


%description -n emacs-%{name}
This package provides emacs support for %{name}


%prep
%setup -q

# spurious-executable-perm
chmod 0644 src/dt_util.c traces/tempest.bt.gz

## Causes data corruption : dinotrace -tempest traces/tempest.bt.gz
# file-not-utf8
#iconv -f iso8859-1 -t utf-8 traces/tempest.bt.gz > traces/tempest.conv
#mv -f traces/tempest.conv traces/tempest.bt.gz

# desktop file
cat > %{name}.desktop << EOF
[Desktop Entry]
Encoding=UTF-8
Name=Waveform viewer
GenericName=Dinotrace
Comment=Dinotrace which can be used with emacs for advance design
Type=Application
Exec=dinotrace
Icon=utilities-system-monitor
Categories=Engineering;Electronics;
EOF


cat > %{name}.el.site-start << EOF
;; Dinotrace mode
(autoload 'dinotrace-update "dinotrace" "Update dinotrace annotations in this buffer" t)
(autoload 'dinotrace-mode   "dinotrace" "Toggle dinotrace annotations in this buffer" t)
;;(global-set-key "\C-x\C-aa" 'dinotrace-update)
;;(global-set-key "\C-x\C-ad" 'dinotrace-mode)
EOF


%build
# Override OPT to prevent configure playing tricks with CFLAGS
%configure OPT=' '
%{__make} %{?_smp_mflags}


%install
%{__make} DESTDIR=%{buildroot} INSTALL="%{_bindir}/install -p" install


# Install emacs mode
%{__install} -d %{buildroot}%{emacs_lispdir}
%{__install} -d %{buildroot}%{emacs_startdir}
pushd lisp/
    for file in dinotrace.el sim-log.el; do
        emacs -batch -f batch-byte-compile $file
        %{__install} -pm 0644 $file ${file}c %{buildroot}%{emacs_lispdir}/
    done
popd
%{__install} -pm 0644 %{name}.el.site-start %{buildroot}%{emacs_startdir}/%{name}-init.el


desktop-file-install --vendor "" \
    --dir %{buildroot}%{_datadir}/applications \
    %{name}.desktop

# FEL Package Validation check
# dinotrace traces/ascii.tra
# dinotrace traces/vcd.vcd


%files
%doc Changes COPYING FAQ TODO dinotrace.txt
%doc traces/
%{_bindir}/%{name}
%{_infodir}/*
%{_datadir}/applications/%{name}.desktop

%files -n emacs-%{name}
%{emacs_lispdir}/%{name}.el*
%{emacs_lispdir}/sim-log.el*
%{emacs_startdir}/%{name}-init.el

%Changelog
* Wed Mar 02 2016 Igor Vlasenko <viy@altlinux.ru> 9.4c-alt1_10
- update to new release by fcimport

* Mon Oct 19 2015 Igor Vlasenko <viy@altlinux.ru> 9.4c-alt1_9
- update to new release by fcimport

* Mon Sep 21 2015 Igor Vlasenko <viy@altlinux.ru> 9.4c-alt1_8
- update to new release by fcimport

* Wed Sep 10 2014 Igor Vlasenko <viy@altlinux.ru> 9.4c-alt1_7
- update to new release by fcimport

* Tue Jul 01 2014 Igor Vlasenko <viy@altlinux.ru> 9.4c-alt1_6
- update to new release by fcimport

* Thu Aug 22 2013 Igor Vlasenko <viy@altlinux.ru> 9.4c-alt1_5
- update to new release by fcimport

* Thu Feb 21 2013 Igor Vlasenko <viy@altlinux.ru> 9.4c-alt1_4
- update to new release by fcimport

* Fri Dec 14 2012 Igor Vlasenko <viy@altlinux.ru> 9.4c-alt1_3
- converted for ALT Linux by srpmconvert tools

