# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install unzip
# END SourceDeps(oneline)
BuildRequires: python-module-PyXML
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name and %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name diveintopython
%define version 5.4
%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

Name:           diveintopython
Version:        5.4
Release:        alt1_34

Summary:        Dive into Python - a python book

Group:          Documentation
License:        GFDL
URL:            http://www.diveintopython.net
Source0:        http://www.diveintopython.net/download/%{name}-common-%{version}.zip
Source1:        http://www.diveintopython.net/download/%{name}-xml-%{version}.zip
Source2:        %{name}.desktop.in

BuildArch:      noarch
Requires:       diveintopython-pdf, xdg-utils
Patch0:         diveintopython-build.xml.patch
Patch1:         diveintopython-build_common.xml.patch
Patch2:         diveintopython-xalan.patch

BuildRequires:  desktop-file-utils, htmldoc, ant >= 1.8.2, xerces-j2, xml-commons-apis
BuildRequires:  python, w3m, java, xalan-j2
Source44: import.info

%description
Dive Into Python is a Python book for experienced programmers.

%package         pdf
Summary:         Dive into Python - a python book
Group:           Documentation
%description     pdf
Dive Into Python is a Python book for experienced programmers.
The PDF version

%package         html
Summary:         Dive into Python - a python book
Group:           Documentation
%description     html
Dive Into Python is a Python book for experienced programmers.
The html version

%package         single-html
Summary:         Dive into Python - a python book
Group:           Documentation
%description     single-html
Dive Into Python is a Python book for experienced programmers.
The single html page version

%package         txt
Summary:         Dive into Python - a python book
Group:           Documentation
%description     txt
Dive Into Python is a Python book for experienced programmers.
The text version

%prep 
%setup -q -b 1
%patch0 -p1 -b .build-all
%patch1 -p1
%patch2 -p1 -b .xalan
mkdir build
mv xml make.sh build.xml build/

find \( -name '*.jar' -o -name '*.py[co]' \) -delete

%build
pushd build
#/bin/sh make.sh
ant -Dxalan=1
popd

%install
pushd build/dist
#cleanup unnecessary duplicates
rm -rf pdf/*.png pdf/*.html pdf/images/
rm -rf txt/*.html

#install the files
find . -type d -exec mkdir -p $RPM_BUILD_ROOT%{_docdir}/%{name}/'{}'  \;
for DIR in * ; do
  find $DIR -type f -exec install -D -m 0644 '{}' $RPM_BUILD_ROOT%{_docdir}/%{name}/'{}' \;
done
popd

#install desktop file
mkdir ${RPM_BUILD_ROOT}%{_datadir}/applications/
cat %{SOURCE2}|sed "s|@DOCDIR@|%{_docdir}/%{name}/|g" > ${RPM_BUILD_ROOT}%{_datadir}/applications/diveintopython.desktop

desktop-file-install  \
        --dir=${RPM_BUILD_ROOT}%{_datadir}/applications \
        --add-category="Documentation"                  \
        ${RPM_BUILD_ROOT}%{_datadir}/applications/diveintopython.desktop

%files 

%files html
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/html

%files pdf
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/pdf
%{_datadir}/applications/diveintopython.desktop

%files single-html
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/htmlflat

%files txt
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/txt

%changelog
