%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define lib_name_orig	libdm
%define lib_major	0
%define lib_name	libdm%{lib_major}
%define devel_name      libdm-devel

Summary:	Data Management API runtime environment
Name:		dmapi
Version:	2.2.12
Release:	alt1_13
Source0:	ftp://oss.sgi.com/projects/xfs/cmd_tars/%{name}-%{version}.tar.gz
Patch0:		dmapi-2.2.10-libexec.patch
Patch1:		fix-build.patch
License:	LGPLv2 and GPLv2
Group:		System/Kernel and hardware
URL:		http://oss.sgi.com/projects/xfs/
BuildRequires:	libxfs-devel
BuildRequires:	pkgconfig(ext2fs)
BuildRequires:	libtool
Source44: import.info

%description
Files required by system software using the Data Management API
(DMAPI).  This is used to implement the interface defined in the
X/Open document:  Systems Management: Data Storage Management
(XDSM) API dated February 1997.  This interface is implemented
by the libdm library.

%package -n	%{lib_name}
Summary:	Main library for %{lib_name_orig}
Group:		System/Libraries
Requires(pre):	filesystem >= 2.1.9
Provides:	%{lib_name_orig} = %{version}-%{release}

%description -n	%{lib_name}
This package contains the library needed to run programs dynamically
linked with %{lib_name_orig}.

%package -n	%{devel_name}
Summary:	Data Management API static libraries and headers
Group:		Development/C
Requires(pre):	filesystem >= 2.1.9
Requires:	%{lib_name} = %{version}
Provides:	%{lib_name_orig}-devel = %{version}-%{release}
Provides:	dm-devel = %{version}-%{release}
Obsoletes:	dm-devel
Provides:	libdm0-devel = %{version}-%{release}
Obsoletes:	libdm0-devel < 2.2.9-2

%description -n	%{devel_name}
dmapi-devel contains the libraries and header files needed to
develop programs which make use of the Data Management API
(DMAPI).  If you install dmapi-devel, you'll also want to install
the dmapi (runtime) package and the xfsprogs-devel package.

%package -n %{devel_name}-static
Summary:        Static library for the %{name} library
Group:          Development/C
Requires:       %{devel_name} = %EVR

%description -n %{devel_name}-static
This package contains the static %{name} library

%files -n %{devel_name}-static
%{_libdir}/*.a


%prep
%setup -q
%patch0 -p1
%patch1 -p1


# fix build on aarch64
cp -af /usr/share/gnu-config/config.{guess,sub} .

%build
%configure
%make_build

%install
make install DIST_ROOT=%{buildroot}/
make install-dev DIST_ROOT=%{buildroot}/

# (sb) installed but unpackaged files
rm -rf %{buildroot}%{_datadir}/doc/dmapi

%files -n %{lib_name}
%{_libdir}/*.so.*

%files -n %{devel_name}
%doc doc/PORTING doc/CHANGES.gz doc/COPYING README
%{_libdir}/*.so
%{_mandir}/man3/*
%{_includedir}/*/*






%changelog
