%filter_from_requires /^python3.Queue./d
%filter_from_requires /^python3.thread./d
# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-python3
# END SourceDeps(oneline)
Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           doclifter
Version:        2.19
Release:        alt2_6
Summary:        Translates documents written in troff macros to DocBook

License:        BSD
URL:            http://www.catb.org/~esr/doclifter/

# http only download, check with sources on gitlab:
# https://gitlab.com/esr/doclifter against possible tampering
Source0:        http://www.catb.org/~esr/%{name}/%{name}-%{version}.tar.gz
# The template for man page translations can be created with this command:
# po4a-updatepo -v -M utf-8 -f man --option groff_code=verbatim -m manlifter.1 -p manlifter.pot
Source1:        https://mariobl.fedorapeople.org/Translations/%{name}/manlifter.1.de.po

# fix shebang in doclifter
Patch0:         %{name}.patch
# fixes for make check
# https://gitlab.com/esr/doclifter/merge_requests/2
Patch1:         0001-Specify-the-location-of-setpython-explicitly-in-test.patch
# causes make check to actually abort on error
Patch2:         0002-Abort-testsuite-on-unexpected-differences.patch

Requires:       libplot libplotter libxmi plotutils
Requires:       python3

BuildArch:      noarch
BuildRequires:  libplot libplotter libxmi plotutils
BuildRequires:  po4a
BuildRequires:  python3
Source44: import.info

%description
The doclifter program translates documents written in troff macros to DocBook.

Lifting documents from presentation level to semantic level is hard, and
a really good job requires human polishing.  This tool aims to do everything
that can be mechanized, and to preserve any troff-level information that might
have structural implications in XML comments.

This tool does the hard parts.  TBL tables are translated into DocBook
table markup, PIC into SVG, and EQN into MathML (relying on pic2svg
and GNU eqn for the last two).

%prep
%setup -q

%patch0
%patch1 -p1
%patch2 -p1

%build
# Nothing to build


%install

install -p -D -m 0755 doclifter %{buildroot}%{_bindir}/doclifter
install -p -D -m 0755 manlifter %{buildroot}%{_bindir}/manlifter
install -p -D -m 0644 doclifter.1 %{buildroot}%{_mandir}/man1/doclifter.1
install -p -D -m 0644 manlifter.1 %{buildroot}%{_mandir}/man1/manlifter.1

# Generate and install localized man page
# TODO: check whether the translation is up to date
mkdir -p man/de
po4a-translate -M utf-8 -f man \
               --option groff_code=verbatim \
               -p %SOURCE1 -m manlifter.1 \
               -l man/de/manlifter.1

install -p -D -m 0644 man/de/manlifter.1 \
        %{buildroot}%{_mandir}/de/man1/manlifter.1

%check
%__make check


%files
%doc README TODO
%doc --no-dereference COPYING
%{_bindir}/manlifter
%{_bindir}/doclifter
%{_mandir}/man1/doclifter.1*
%{_mandir}/man1/manlifter.1*
%{_mandir}/de/man1/manlifter.1.*


%changelog
