# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define commit ba6994a37592f02b6268e9f0d729c8770e1467e6

Name:          drmr
Version:       git20120709
Release:       alt1_7
Summary:       An LV2 sampler plugin that plays hydrogen drum kits
Group:         Sound
License:       GPLv3
URL:           https://github.com/nicklan/drmr
Source0:       https://github.com/nicklan/drmr/archive/%{commit}.tar.gz

BuildRequires:  cmake
BuildRequires:  libsamplerate-devel
BuildRequires:  gtk2-devel
BuildRequires:  pkgconfig(sndfile)
BuildRequires:  pkgconfig(lv2)
BuildRequires:  libexpat-devel

Requires:       lv2-example-plugins
Requires:       hydrogen
Requires:       hydrogen-drumkits
Source44: import.info


%description
DrMr is an LV2 sampler plugin. It's main reason to exist is to give a way 
for lv2 hosts to have a built in drum synth that can save its entire
state (i.e. no need to go out to external tools and no need to
save extra state). DrMr currently supports the following:

* Control via midi
* Scan for and load hydrogen drum kits
* Multi-layer hydrogen kits (will pick layer based on that samples set gain)
* Kit is set via an LV2 control (see note 1 below)
* LV2 controls for gain on first 32 samples of kit (see note 2 below)
* LV2 controls for pan on first 32 samples of kit (see note 2 below)
* GTK ui that can select a kit and control gain/pan on each sample

%prep
%setup -q -n drmr-%{commit} 
sed -i -e '/CMAKE_C_FLAGS/d' CMakeLists.txt

%build
export CFLAGS="%{optflags} -pthread"
%{mageia_cmake} -DLV2_INSTALL_DIR:PATH=%{_lib}/lv2
%mageia_cmake_build

%install
%mageia_cmake_install

%files
%{_libdir}/lv2/*



%changelog
