# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: /usr/bin/makedeltarpm gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name drpm
%global _hardened_build 1

%define major         0
%define libname       lib%{name}%{major}
%define libname_devel lib%{name}-devel

Name:           drpm
Version:        0.5.2
Release:        alt1_3
Summary:        A small library for fetching information from DeltaRPM packages
Group:          System/Libraries
License:        LGPLv2+
URL:            https://github.com/rpm-software-management/%{name}
Source0:        https://github.com/rpm-software-management/%{name}/releases/download/%{version}/%{name}-%{version}.tar.bz2
Patch0:         drpm_cmake_minimum_version.patch

BuildRequires:  pkgconfig(rpm)
BuildRequires:  pkgconfig(zlib)
BuildRequires:  pkgconfig(bzip2)
BuildRequires:  pkgconfig(liblzma)
BuildRequires:  pkgconfig(openssl)
BuildRequires:  pkgconfig(libzstd)

BuildRequires:  ccmake cmake ctest
BuildRequires:  pkgconfig(cmocka) >= 1.0
%ifnarch aarch64
BuildRequires:  valgrind
%endif
BuildRequires:  doxygen
Source44: import.info

%package -n %{libname}
Summary:        A small library for fetching information from DeltaRPM packages
Group:          System/Libraries

%package -n %{libname_devel}
Summary:        C interface for the drpm library
Group:          Development/C
Provides:       %{name}-devel = %{version}-%{release}
Provides:       %{name}-devel = %{version}-%{release}
Requires:       %{libname} = %{version}-%{release}

%description
The drpm package provides a small library allowing one to fetch
various info from DeltaRPM packages.

%description -n %{libname}
This package provides a small library allowing one to fetch
information from DeltaRPM packages.

%description -n %{libname_devel}
This package provides a C interface (drpm.h) for the drpm library.

%prep
%setup -q
%patch0 -p1


%build
%{mageia_cmake}
%mageia_cmake_build

%install
%mageia_cmake_install

%check
%{mageia_ctest}

%files -n %{libname}
%{_libdir}/libdrpm.so.%{major}
%{_libdir}/libdrpm.so.%{major}.*
%doc --no-dereference COPYING

%files -n %{libname_devel}
%{_libdir}/libdrpm.so
%{_includedir}/drpm.h
%{_libdir}/pkgconfig/drpm.pc



%changelog
