# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python
# END SourceDeps(oneline)
BuildRequires: python-devel
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: dtrx
Version: 7.1        
Release: alt2_13
Summary: Intelligent archive extractor

Group: Archiving/Other
License: GPLv3+
URL: http://brettcsmith.org/2007/dtrx/
Source0: http://brettcsmith.org/2007/dtrx/%{name}-%{version}.tar.gz

BuildArch: noarch
#The following packages are needed for check section
BuildRequires:  xz,ncompress,cabextract,p7zip,libunshield,dpkg,python-module-yaml
BuildRequires:  %{__python}

# The following packages are the backend tools for dtrx
Requires: bzip2
Requires: cpio
Requires: gzip gzip-utils
Requires: tar
Requires: xz
Requires: ncompress
Requires: cabextract
Requires: xz
Requires: p7zip
Requires: libunshield
Requires: dpkg
Requires: unzip
Source44: import.info

%description
dtrx extracts archives in a number of different formats; it currently
supports tar, zip (including self-extracting .exe files), cpio, rpm, deb,
gem, 7z, cab, rar (if unrar is installed), lhz (if lha is installed), 
and InstallShield files.
It can also decompress files compressed with gzip, bzip2, lzma, xz,or compress.

In addition to providing one command to handle many different archive
types, dtrx also aids the user by extracting contents consistently.  By
default, everything will be written to a dedicated directory that's named
after the archive.  dtrx will also change the permissions to ensure that the
owner can read and write all those files.

%prep
%setup -q


%build

%install
%{__python} setup.py install --prefix=%{buildroot}/%{_prefix} 

%check
%{__python} tests/compare.py

%files
%{_bindir}/dtrx
%{python_sitelibdir_noarch}/*
%doc NEWS README
%doc --no-dereference COPYING


%changelog
