Group: Video
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global date 2024-03-24
%global git 7098bdd27548

#WARNING: should be monotonically incremented
%global rel 11

# WARNING: You should probably never touch those fields
Version:	1
Name:		dtv-scan-tables
Summary:	Digital TV scan tables
Release:	alt2_%{rel}.%(echo %{date} | tr -d -)git%{git}.2

#2013-07-19: License discussed in: https://bugzilla.redhat.com/show_bug.cgi?id=986051#c4
#and https://gitlab.com/fedora/legal/fedora-license-data/-/issues/580#note_2155500881
License:	LicenseRef-Not-Copyrightable
URL:		https://git.linuxtv.org/dtv-scan-tables.git
Source0:	https://linuxtv.org/downloads/dtv-scan-tables/dtv-scan-tables-%{date}-%{git}.tar.bz2
BuildArch:	noarch
%if 0%{?fedora} >= 40
BuildRequires:	v4l-utils
%else
BuildRequires:	ir-keytable v4l-utils
%endif
# FPC permission for Conflicts:
# https://lists.fedoraproject.org/pipermail/packaging/2013-July/009346.html
# https://fedorahosted.org/fpc/ticket/316
Conflicts:	dvb-apps < 1.1.2-6.1488.f3a70b206f0f
Source44: import.info

%description
This package contains digital TV scan tables that are used by TV applications
to scan for channels.

%package legacy
Group: Video
Summary:	Digital TV scan tables in the legacy DVBv3 format

%description legacy
This package contains digital TV scan tables that are used by TV applications
to scan for channels in the legacy DVBv3 format, compatible with the old
dvb-apps.

%prep
%setup -T -c
tar xf %{SOURCE0} --transform="s,/usr/share/dvb/,,"

%build
make dvbv3

%install
make DATADIR=%{buildroot}/%{_datadir} install install_v3

%files legacy
%doc --no-dereference COPYING COPYING.LGPL
%{_datadir}/dvbv3/

%files
%doc --no-dereference COPYING COPYING.LGPL
%{_datadir}/dvbv5/

%changelog
