# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           duckmarines
Version:        1.0c
Release:        alt1_7
Summary:        Frantic couch multiplayer action
Group:          Games/Arcade
License:        zlib and CC-BY-SA 4.0 and CC-BY 3.0 and CC-BY 4.0
URL:            https://tangramgames.dk/games/duckmarines
#Source0:        https://github.com/SimonLarsen/duckmarines/archive/v%%{version}.tar.gz
# Forked version replacing nonfree music by libre tracks
Source0:        https://github.com/akien-mga/duckmarines-libre/archive/v%{version}-libre/%{name}-libre-%{version}-libre.tar.gz

BuildArch:      noarch
BuildRequires:  zip
Requires:       love0.10
Source44: import.info

%description
Duck Marines is a cross-platform free software PC remake of Sonic Team's
ChuChu Rocket.

Duck Marines attempts to recreate the magic from the local multiplayer
of ChuChu Rocket while adding new elements like mini games, a level editor,
colorful pixel art and more.

Mageia's version uses free music as selected by the FreeGameDev community.

%files
%doc README.md LICENSE.md
%{_datadir}/applications/%{name}.desktop
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/%{name}.love
%{_iconsdir}/hicolor/*/apps/%{name}.*

#----------------------------------------------------------------------------

%prep
%setup -q -n %{name}-libre-%{version}-libre


%build

%install
# Create and install the .love (zip) archive
zip -9 -r %{name}.love .
install -D -m644 %{name}.love %{buildroot}%{_gamesdatadir}/%{name}/%{name}.love

# Launcher script
cat > %{name}.sh << EOF
#!/bin/sh
love0.10 %{_gamesdatadir}/%{name}/%{name}.love
EOF
install -D -m755 %{name}.sh %{buildroot}%{_gamesbindir}/%{name}

# Desktop entry
cat > %{name}.desktop << EOF
[Desktop Entry]
Name=Duck Marines
GenericName=Frantic couch multiplayer action
Comment=A frantic couch multiplayer action
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;ArcadeGame;
EOF
install -D -m644 %{name}.desktop %{buildroot}%{_datadir}/applications/%{name}.desktop

# Icon
pushd res/icons
  install -D -m644 32x32.png %{buildroot}%{_iconsdir}/hicolor/32x32/apps/%{name}.png
  install -D -m644 48x48.png %{buildroot}%{_iconsdir}/hicolor/48x48/apps/%{name}.png
  install -D -m644 vector.svg %{buildroot}%{_iconsdir}/hicolor/scalable/apps/%{name}.svg
popd


%changelog
