# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: /usr/bin/ccache gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define oname   DustRacing2D

Name:           dustrac
Version:        2.1.1
Release:        alt1_3
Summary:        Dust Racing 2D is a traditional top-down car racing game including a level editor
Group:          Games/Sports
License:        GPLv3+
URL:            https://juzzlin.github.io/DustRacing2D
Source0:        https://github.com/juzzlin/DustRacing2D/archive/%{version}/%{name}-%{version}.tar.gz
Patch0:         dustrac-cmake-4.0.patch

BuildRequires:  ccmake cmake ctest
BuildRequires:  pkgconfig(glu)
BuildRequires:  pkgconfig(openal)
BuildRequires:  pkgconfig(Qt5Core)
BuildRequires:  pkgconfig(Qt5Gui)
BuildRequires:  pkgconfig(Qt5Help)
BuildRequires:  pkgconfig(Qt5OpenGL)
BuildRequires:  pkgconfig(Qt5Sql)
BuildRequires:  pkgconfig(Qt5Test)
BuildRequires:  pkgconfig(Qt5Xml)
BuildRequires:  pkgconfig(vorbis)
BuildRequires:  qt5-designer qt5-tools

Requires:       libqt5-sql
Source44: import.info

%description
Dust Racing 2D (dustrac) is an open source, tile-based 2D racing game
developed by Jussi Lind and contributors.

The purpose of the game is to race against challenging computer players on
different race tracks. Finishing in TOP-6 will unlock a new race track.
Only a small portion of the race track is visible on the scrolling screen.

There's also an option for a split-screen two player game. Dust Racing 2D
comes with a Qt-based level editor that makes creating new race tracks easy.

%prep
%setup -q -n %{oname}-%{version}
%patch0 -p1


%build
%{mageia_cmake_qt5} \
       -DReleaseBuild=1 \
       -DBUILD_SHARED_LIBS=OFF \
       -DBIN_PATH=%{_gamesbindir} \
       -DDATA_PATH=%{_gamesdatadir}/%{name} \
       -DDOC_PATH=%{_docdir}/%{name}
%mageia_cmake_build

%install
%mageia_cmake_install

# Hicolor is sufficient
rm -rf %{buildroot}%{_datadir}/pixmaps

%files
%{_gamesbindir}/%{name}-editor
%{_gamesbindir}/%{name}-game
%{_gamesdatadir}/%{name}/
%{_datadir}/applications/%{name}*.desktop
%{_datadir}/metainfo/%{name}.appdata.xml
%{_docdir}/%{name}/
%{_iconsdir}/hicolor/64x64/apps/%{name}*.png


%changelog
