Group: Video
# BEGIN SourceDeps(oneline):
BuildRequires: perl(HTML/Form.pm) perl(HTTP/Cookies.pm) perl(LWP.pm) perl(XML/XPath.pm) perl(XML/XPath/XMLParser.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# There's not been a release in a long time for dvb-apps
# We use a Release based on the ChangeSet number and hash
%define hgr 1505
%define hgver 3d43b280298c

Name:    dvb-apps
Version: 1.1.2
Release: alt1_19.%{hgr}.%{hgver}
Summary: Utility, demo and test applications using the Linux DVB API

License: GPLv2+
URL:     http://www.linuxtv.org/wiki/index.php/LinuxTV_dvb-apps

Source0: http://linuxtv.org/hg/dvb-apps/archive/%{hgver}.tar.bz2
Patch0:  dvb-apps-Make.patch
Patch1:  dvb-apps-Docs.patch
Patch2:  dvb-apps-fix-ftbfs.patch
Patch3:  linuxtv-dvb-apps-1.1.1.20100223-perl526.patch

BuildRequires:  gcc
BuildRequires:  libusb-compat-devel
BuildRequires:  rdma-core-devel
BuildRequires:  perl-devel
Requires: dtv-scan-tables-legacy
Source44: import.info
Patch33: dvb-apps-alt-linkage.patch

%description
The LinuxTV dvb-apps package contains some Linux DVB API applications and a set 
of utilities that both the developer and end user alike will find quite useful. 
Specifically, the utilities are geared towards the initial setup, testing, and 
operation of a DVB device, whether it be of the software decoding or hardware 
decoding type.

%prep
%setup -q -n %{name}-%{hgver}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1


# Rename to non generic name
mv util/scan/scan.c util/scan/scandvb.c
mv util/zap/zap.c util/zap/dvbzap.c

cd util
install -pm 644 av7110_loadkeys/README ../README.av7110_loadkeys
install -pm 644 scan/README ../README.scandvb
install -pm 644 szap/README ../README.szap
install -pm 644 ttusb_dec_reset/README ../README.ttusb_dec_reset
cd ..
%patch33 -p1

%build
LDFLAGS="$RPM_LD_FLAGS" %make_build libdir=%{_libdir} V=1

%install
%makeinstall_std INSTALL='install -p' libdir=%{_libdir}
chmod -c +x %{buildroot}%{_libdir}/lib*.so

#Remove static libraries
find %{buildroot} -name '*.a' -delete



%files
%doc --no-dereference COPYING COPYING.LGPL
%doc README README.*
%{_bindir}/*
%{_datadir}/dvb/av7110_loadkeys/
%{_libdir}/libdvbapi.so
%{_libdir}/libdvbcfg.so
%{_libdir}/libdvben50221.so
%{_libdir}/libdvbsec.so
%{_libdir}/libucsi.so
# Exclude for the moment as they're not used by shipped binaries
%exclude %{_libdir}/libesg.so
%exclude %{_includedir}/*
# dvbscan doesn't work and is obsolete, don't install it
%exclude %{_bindir}/dvbscan

%changelog
