Group: Communications
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%add_optflags -fcommon
Name:		echolinux
Version:	0.17a
Release:	alt2_33
Summary:	Linux echoLink client

License:	GPL+
URL:		http://cqinet.sourceforge.net/
Source0:	echolinux-0.17a-nogsm.tar.gz
# We do not know the license for gsm.h (and libgsm.a)
# We use this script to remove gsm.h and libgsm.a before shipping it.
# Download the upstream tarball and invoke this script while in the
# tarball's directory:
# ./generate-echolinux-tarball.sh 1.0
Source1: generate-echolinux-tarball.sh
#xform changed include paths - https://sourceforge.net/tracker/index.php?func=detail&aid=2198156&group_id=56357&atid=480282
Patch0:		echolinux-0.17a-includes.patch
#allow env install paths - https://sourceforge.net/tracker/index.php?func=detail&aid=2198185&group_id=56357&atid=480282
Patch1:		echolinux-0.17a-installdir.patch
#do not link against static library (packaged .la file) - https://sourceforge.net/tracker/index.php?func=detail&aid=2198200&group_id=56357&atid=480282
Patch2:		echolinux-0.17a-nostatic.patch
#prefer -O2 instead of -O3
Patch3:		echolinux-0.17a-gcc.patch
Patch4:		echolinux-0.17a-optflags.patch
Patch5:		echolinux-c99.patch

BuildRequires:  gcc
BuildRequires:	libxforms libxforms-devel libXpm libXpm-devel, libgsm-devel, desktop-file-utils
Source44: import.info
Patch33: echolinux-0.17a-alt-as-needed-and-xforms.patch
#Requires:	

%description
EchoLinux is a "command line" driven engine that performs all of the actions
necessary to initiate sessions, accept connections and maintain connections
with other echoLink users. It also handles the compression/decompression of
the audio stream.

%prep
%setup -q
%patch0 -p1 -b .includes
%patch1 -p1 -b .installdir
%patch2 -p1 -b .nostatic
%patch3 -p1 -b .gcc
%patch4 -p1 -b .optflags
%patch5 -p1 -b .c99
sed -i 's/\r//' Using_EchoLinux.txt
sed -i 's/Encoding=UTF-8//g' %{name}.desktop
sed -i 's/.png//g' %{name}.desktop
sed -i 's/Application;Network;/Network;HamRadio;/g' %{name}.desktop
%patch33 -p1


%build
%make_build -e CFLAGS="%{optflags}"


%install
#fix perms on packages file
chmod -x README
mkdir -p %{buildroot}%{_bindir}
make install DESTDIR=%{buildroot}%{_bindir} INSTALL="install -p"
mkdir -p %{buildroot}%{_datadir}/pixmaps/
mkdir -p %{buildroot}%{_sysconfdir}/%{name}
cp echolinux/*.txt echolinux/*.wav %{buildroot}%{_sysconfdir}/%{name}
cp pixmaps/echolinux_48x48.png %{buildroot}%{_datadir}/pixmaps/
desktop-file-install \
	--dir=%{buildroot}%{_datadir}/applications %{name}.desktop



%files
%doc gpl.txt README Using_EchoLinux.txt
%{_bindir}/echoaudio
%{_bindir}/echogui
%{_bindir}/echolinux
%config(noreplace) %{_sysconfdir}/echolinux
%{_datadir}/pixmaps/echolinux_48x48.png
%{_datadir}/applications/%{name}.desktop


%changelog
