# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
BuildRequires: unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	Graph editor written in Java
Name:		edugraphe
Version:	1.1
Release:	alt1_16
Group:		Sciences/Mathematics
License:	GPLv2
# Upstream seems dead, the website does not exist anymore
URL:		http://joel.amblard.pagesperso-orange.fr/prg/edu/index.html
Source0:	%{name}-%{version}.zip
Source1:	%{name}.png
BuildRequires:	java-devel-default /proc
Requires:	java
BuildArch:	noarch
Source44: import.info

%description
Easy-to-use graph editor in Java, particularly well suited
for educational uses. It can plot functions and all sorts of
curves, numerical sequences, and solve graphically and
numerically some typical problems of secondary education.
Edugraphe is available in English and French.

%files
%{_bindir}/%{name}
%{_javadir}/edugraphe.jar
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/%{name}.*

#--------------------------------------------------------------------

%prep
%setup -q

%build
export JAVA_TOOL_OPTIONS=-Dfile.encoding=UTF8
pushd source
sh compile.sh
popd

%install
mkdir -p %{buildroot}%{_javadir}
cp source/classes/edugraphe.jar %{buildroot}%{_javadir}

mkdir -p %{buildroot}%{_bindir}
cat > %{buildroot}%{_bindir}/%{name} << EOF
#!/bin/bash
java -jar %{_javadir}/%{name}.jar
EOF
chmod +x %{buildroot}%{_bindir}/%{name}

# desktop file
install -d -m755 %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Name=Edugraphe
GenericName=Graph editor written in Java
GenericName[ru]=Графический редактор, написанный на Java
Comment=Plots functions and numerical sequences
Comment[ru]=Построение функций и числовых последовательностей
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Education;Math;
EOF

mkdir -p %{buildroot}%{_datadir}/pixmaps
install -m644 %{SOURCE1} %{buildroot}%{_datadir}/pixmaps


%changelog
