Group: System/Base
# BEGIN SourceDeps(oneline):
BuildRequires: perl-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		egd
Summary: 	Entropy Gathering Daemon
Version:	0.9
Release:	alt2_34
# Automatically converted from old format: GPL+ or MIT - review is highly recommended.
License:	GPL-1.0-or-later OR LicenseRef-Callaway-MIT
Source0:	http://download.sourceforge.net/egd/%{name}-%{version}.tar.gz
URL:		http://egd.sourceforge.net/
# https://bugzilla.redhat.com/show_bug.cgi?id=784384
# https://sourceforge.net/tracker/?func=detail&aid=3479661&group_id=13778&atid=113778
Patch0:         egd-0.9-ip-neigh.patch
BuildRequires:	rpm-build-perl
BuildRequires:	perl(Digest/SHA1.pm), perl(ExtUtils/MakeMaker.pm), perl(FindBin.pm), perl(IO/Socket.pm)
BuildArch:	noarch
# These are necessary for egd to do anything useful for entropy.
Requires:	procps, iproute2, coreutils cfdisk eject fdisk getopt hwclock look lsblk rfkill setarch sfdisk shadow-change util-linux tcpdump tcpslice
Source44: import.info

%description
EGD is an Entropy Gathering Daemon meant to be used on systems that can run GPG 
but which don't have a convenient (or reliable) source of random bits. It is a 
regular user-space program that sits around, running programs like 'w' and 
'last' and 'vmstat', collecting the randomness (or at least the 
unpredictability) inherent in the output of these system statistics programs 
when used on a reasonably busy system. It slowly stirs the output of these 
gathering programs into a pool of entropy, much like the linux kernel device, 
and allows other programs to read out random bits from this pool.

%prep
%setup -q
%patch0  -p1 -b .neigh

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} ';'
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null ';'
chmod -R u+w $RPM_BUILD_ROOT/*

%files
%doc COPYING COPYING.xfree86 README
%{_bindir}/egd.pl

%changelog
