# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: /usr/bin/xvfb-run gcc-c++ libpoppler-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%ifarch %{arm}
%define enable_tests	0
%else
%define enable_tests	0
%endif

Name:		engauge-digitizer
Version:	12.9.1
Release:	alt1_1
Summary:	Convert graphs or map files into numbers
Group:		Sciences/Other
License:	GPLv2+
URL:		https://github.com/akhuettel/engauge-digitizer
Source0:	https://github.com/akhuettel/engauge-digitizer/archive/v%{version}/%{name}-%{version}.tar.gz
Source1:	%{name}.appdata.xml
Source2:	%{name}.svg
Source3:	%{name}-with-name.svg
Patch0:		%{name}-10.1-fix_test_script.patch
Patch1:		%{name}-11.3-fix_translations_path.patch
### Main building
BuildRequires:	desktop-file-utils
BuildRequires:	qt5-tools qt6-designer qt6-tools
BuildRequires:	qt6-assistant
BuildRequires:	qt6-base-devel
BuildRequires:	qt6-base-devel
BuildRequires:	qt6-tools-devel
BuildRequires:	qt6-base-devel
BuildRequires:	qt6-base-devel
BuildRequires:	qt6-base-devel
BuildRequires:	qt6-base-devel
BuildRequires:	pkgconfig(poppler-qt6)
BuildRequires:	pkgconfig(fftw3)
BuildRequires:	pkgconfig(libopenjp2)
BuildRequires:	pkgconfig(log4cpp)

### Doxygen for documentation
BuildRequires:	doxygen
BuildRequires:	texlive-collection-basic

%if %{enable_tests}
### Xvfb is needed to run a virtual X server used by tests
BuildRequires:	xorg-xvfb xvfb-run
BuildRequires:	qt6-base-devel
%endif
Source44: import.info

%description
The Engauge Digitizer tool accepts image files
(like PNG, JPEG and TIFF) containing graphs,
and recovers the data points from those graphs.
The resulting data points are usually used as input
to other software applications.
Conceptually, Engauge Digitizer is the opposite of
a graphing tool that converts data points to graphs.
The process is shown below - an image file is imported,
digitized within Engauge, and exported as a table of
numeric data to a text file.
Work can be saved into an Engauge DIG file.

More details at "https://github.com/akhuettel/engauge-digitizer/"

%package	samples
Summary:	Sample files for %{name}
Group:		Documentation
BuildArch:	noarch

%description	samples
This package contains several sample image files that may be imported into
Engauge Digitizer.

More details in "/usr/share/doc/engauge-digitizer-samples/README"

%package	doc
Summary:	HTML documentation of %{name}
Group:		Documentation
BuildArch:	noarch

%description	doc
HTML documentation of %{name}.

%prep
%setup -q

%if %{enable_tests}
### optimization flags for compilers
%patch0  -p1
sed -e 's|RPM_OPT_FLAGS|"%{optflags}"|g' -i src/build_and_run_all_cli_tests
%endif

%patch1  -p1

### Remove default -O1 optimization
sed -e 's|-O1||g' -i engauge.pro

### Active support to jpeg2000 and support to pdf
sed -e 's|CONFIG += qt warn_on thread|CONFIG += qt warn_on thread jpeg2000 pdf|g' -i engauge.pro

### Remove spurious executable permissions
for i in `find src -type f \( -name "*.cpp" -o -name "*.h" \)`; do
chmod a-x $i
done

%build
export OPENJPEG_INCLUDE=%{_includedir}/openjpeg-2.5
export OPENJPEG_LIB=%{_libdir}
export POPPLER_INCLUDE=%{_includedir}/poppler/qt6
export POPPLER_LIB=%{_libdir}
export ENGAUGE_RELEASE=1

### Build engauge
%{_qt6_bindir}/lrelease engauge.pro
%qmake_qt6 engauge.pro DEFINES+=HELPDIR=%{_docdir}/%{name}/help
%make_build

### Build HELP files
pushd help
mkdir ../bin/documentation
%{_qt6_libexecdir}/qhelpgenerator engauge.qhcp -o engauge.qhc
mv engauge.qch ../bin/documentation
mv engauge.qhc ../bin/documentation
rm -f build
popd

### Build HTML/Latex documentation files
pushd src
doxygen
popd

%install
### Install binary
mkdir -p %{buildroot}%{_bindir}
install -p -m 755 bin/Engauge %{buildroot}%{_bindir}/engauge

### Install sample files
mkdir -p %{buildroot}%{_datadir}/%{name}/samples
pushd samples
install -p -m 644 *.gif *.jp* *.p* *.bmp *.x* %{buildroot}%{_datadir}/%{name}/samples
popd

### Install img files
mkdir -p %{buildroot}%{_datadir}/%{name}/img
install -p -m 644 src/img/* %{buildroot}%{_datadir}/%{name}/img

### Install appdata file
mkdir -p %{buildroot}%{_metainfodir}
install -p -m 644 %{SOURCE1} %{buildroot}%{_metainfodir}

### Install icons svg
mkdir -p %{buildroot}%{_iconsdir}/hicolor/scalable/apps
install -p -m 644 %{SOURCE2} %{buildroot}%{_iconsdir}/hicolor/scalable/apps
install -p -m 644 %{SOURCE3} %{buildroot}%{_iconsdir}/hicolor/scalable/apps

### Install translation files
mkdir -p %{buildroot}%{_datadir}/%{name}/translations
install -p -m 0644 translations/*.qm %{buildroot}%{_datadir}/%{name}/translations/

### Install .desktop file
mkdir -p %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop <<EOF
[Desktop Entry]
Name=Engauge Digitizer
Type=Application
Comment=Extracts data points from images of graphs
Comment[fr]=Extraits des points de données à partir d'images de graphiques
TryExec=engauge
Exec=engauge %%F
MimeType=text/plain;
Categories=Education;Science;DataVisualization;
Icon=%{name}-with-name
Keywords=analog;digital;converter;
EOF

%check
### Tests
%if %{enable_tests}
pushd src
xvfb-run -s "-screen 0 640x480x24" -a  sh -x ./build_and_run_all_cli_tests
%endif

%files
%doc README.md help/
%doc bin/documentation/engauge.qhc bin/documentation/engauge.qch
%doc --no-dereference LICENSE
%{_bindir}/engauge
%{_metainfodir}/%{name}.appdata.xml
%{_datadir}/applications/%{name}.desktop
%{_datadir}/%{name}/
%{_iconsdir}/hicolor/scalable/apps/%{name}*.svg
%exclude %{_datadir}/%{name}/samples

%files samples
%doc samples/README
%doc --no-dereference LICENSE
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/samples

%files doc
%doc README.md doc/doxygen/html
%doc --no-dereference LICENSE


%changelog
