# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/python3-config /usr/bin/ruby libcrypt-devel libtinfo-devel valgrind-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%filter_from_requires /^python2.7._epic./d
Name:		epic5
Epoch:		0
Version:	3.0.3
Release:	alt1_2
Summary:	(E)nhanced (P)rogrammable (I)RC-II (C)lient
Group:		Networking/IRC
License:	BSD
URL:		https://www.epicsol.org/
Source0:	https://ftp.epicsol.org/pub/epic/EPIC5-PRODUCTION/%{name}-%{version}.tar.xz
# Amnesiac 2.0.2 release updated on Jul 26 2010 @ 20:09
Source2:	http://amnesiac.ircii.org/amnesiac2.0.2cvs51.tgz
BuildRequires:	pkgconfig(libarchive)
BuildRequires:	pkgconfig(ncurses)
BuildRequires:	pkgconfig(openssl)
BuildRequires:	pkgconfig(ruby)
BuildRequires:	gem
BuildRequires:	pkgconfig(tcl)
BuildRequires:	perl-devel
Source44: import.info

%description
EPIC is an irc client project. The EPIC software was forked from
ircII-2.8.2 in fall 1994. There have been 5 generations of EPIC.

EPIC's development model is to provide tools to scripters rather than
features to end users. Out of the box, EPIC behaves much the same way
ircII-2.8.2 did in 1994. To truly leverage EPIC, you will need a
script pack. This %{_vendor} package includes the Amnesia script pack,
see http://amnesiac.ircii.org/

%prep
%setup -q -T -b 0


perl -pi -e 's|/usr/local/bin/perl5|%{__perl}|' regress/crash-irc

# silence rpmlint and convert to utf8
iconv -f iso8859-1 -t utf-8 WISHLIST > WISHLIST.conv && mv -f WISHLIST.conv WISHLIST
iconv -f iso8859-1 -t utf-8 COPYRIGHT > COPYRIGHT.conv && mv -f COPYRIGHT.conv COPYRIGHT
iconv -f iso8859-1 -t utf-8 UPDATES > UPDATES.conv && mv -f UPDATES.conv UPDATES
iconv -f iso8859-1 -t utf-8 regress/stat > regress/stat.conv && mv -f regress/stat.conv regress/stat

%build
autoreconf -vfi
%configure \
		--with-ipv6 \
		--with-perl \
		--with-ruby \
		--with-ssl \
		--without-socks \
		--with-tcl=%{_libdir}/tclConfig.sh
%make_build

%install
%makeinstall_std libexecdir=%{_bindir} sharedir=%{_datadir}

tar -xf %{SOURCE2} -C %{buildroot}%{_datadir}/%{name}/script

# FIXME for correct assignment of rights of all script files
chmod 0755 %{buildroot}%{_datadir}/%{name}/script/epic-crypt-gpg{,-aa}
chmod 0755 %{buildroot}%{_datadir}/%{name}/script/alloc_dump_summary.sh

%files
%doc BUG_FORM COPYRIGHT FILES WISHLIST KNOWNBUGS README
%doc README-CRYPTO UPDATES doc/* regress
%{_bindir}/%{name}
%{_bindir}/%{name}-*
%{_datadir}/%{name}/
%{_bindir}/%{name}-wserv4
%{_mandir}/man1/%{name}.1*


%changelog
