Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}

Summary: Automated theorem prover for first-order equational logic
Name: eqp
Version: 09e
Release: alt2_20
License: Public Domain
URL: http://www.cs.unm.edu/~mccune/eqp/
Source0: http://www.cs.unm.edu/~mccune/old-ftp/eqp-09e.tar.gz
# file to clarify the software license
Patch0: eqp-09e-license.patch
# patches for some missing function prototypes
Patch1: eqp-09e-missing-proto.patch
# patches for printing of pointer variables
Patch2: eqp-09e-printf.patch
# patches for duplicate definition of the Clocks global
Patch3: eqp-09e-clocks.patch

BuildRequires:  gcc
Source44: import.info
%description
EQP is an automated theorem proving program for first-order equational
logic. Its strengths are good implementations of associative-commutative
unification and matching, a variety of strategies for equational
reasoning, and fast search. It seems to perform well on many
problems about lattice-like structures.

EQP is not a stable and polished production theorem prover like Otter
or Prover9. Since it has obtained several interesting results, it was
decided to make it available (including the source code) to everyone, with
no restrictions (and of course no warranty either). EQP's documentation
is not great, but if you already know Otter, you probably will not have
great difficulty in learning to use EQP.

In the early 1930's, it was postulated that every Robbin's Algebra,
(named after Herbert Ellis Robbins), must also be a Boolean Algebra. Many
human mathematicians attempted to find a proof, or a counter-example
of this conjecture, but failed. The EQP automated theorem prover
(and its author William McCune) made history by providing the first
known proof in 1996. The EQP input files for proving Robbin's
Conjecture can be found in the package documentation directory
%{_docdir}/%{name}-%{version}/examples/robbins/

%prep
%setup -q
%patch0 -p1 -b .license
%patch1 -p1 -b .missing-proto
%patch2 -p1 -b .printf
%patch3 -p1 -b .clocks

%build
# upstream does not use autoconf, just run make
%make_build CFLAGS="%{optflags} -DTP_RUSAGE" eqp

%install
# install the executable as "eqp"
install -d                   ${RPM_BUILD_ROOT}%{_bindir}
install -m 755 eqp%{version} ${RPM_BUILD_ROOT}%{_bindir}/eqp
# remove the "go" shell script from the examples subdir (no executables in doc!)
rm -f examples/go

%check
# define a function to run the eqp executable and test if a proof was found
run_eqp( )
{
  # if a proof is found, eqp will return status = 10
  { ./eqp%{version} < ${1} > /dev/null 2>&1 ; RC=${?} ; } || true
  # check the return status to see if a proof was found
  test ${RC} -eq 10
}
# run some of the simple examples as rudimentary tests of the executable,
# proofs should be found quickly in all of these examples provided with eqp
run_eqp "examples/ortholattice/e2.in"
run_eqp "examples/ring/x2.in"
run_eqp "examples/robbins/eqp-lemma0.in"

%files
%doc ChangeLog Manual.txt README basic.doc examples
%doc --no-dereference LICENSE
%attr(0755,root,root) %{_bindir}/eqp

%changelog
