# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define major 0
%define libname liberfa%{major}
%define libname_virt    liberfa
%define develname liberfa-devel

Name: erfa
Version: 2.0.1
Release: alt1_2
Summary: Essential Routines for Fundamental Astronomy
Group: Sciences/Astronomy
License: BSD
URL: https://github.com/liberfa/erfa
BuildRequires: meson
BuildRequires: ccmake cmake ctest
Source0: https://github.com/liberfa/erfa/releases/download/v%{version}/%{name}-%{version}.tar.xz
Source44: import.info

%description
ERFA is a C library containing key algorithms for astronomy, and is 
based on the SOFA library published by the International Astronomical 
Union (IAU).

%package -n %{develname}
Summary: Development files for %{name}
Group: Sciences/Astronomy
Requires: %{libname_virt} = %{version}-%{release}
Provides: %{name}-devel = %{version}-%{release}

%description -n %{develname}
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%package -n %{libname}
Summary: Essential Routines for Fundamental Astronomy
Group: Sciences/Astronomy
Provides: %{name} = %{version}-%{release}
Provides: %{libname_virt} = %{version}-%{release}
Provides: %{name} = %{version}-%{release}
%description -n %{libname}
ERFA is a C library containing key algorithms for astronomy, and is 
based on the SOFA library published by the International Astronomical 
Union (IAU).

%prep
%setup -q


%build
%meson
%meson_build

%install
%meson_install

%check
%meson_test

%files -n %{libname}
%doc README.rst INFO
%doc --no-dereference LICENSE
%{_libdir}/liberfa.so.*

%files -n %{develname}
%{_libdir}/liberfa.so
%{_includedir}/erfa*.h
%{_libdir}/pkgconfig/erfa.pc



%changelog
