Group: Graphical desktop/Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/ctags /usr/bin/desktop-file-install /usr/bin/gdb /usr/bin/tic gcc-c++ imake libICE-devel libSM-devel libX11-devel libXext-devel libXres-devel libXt-devel libopenmotif-devel libutempter-devel xorg-cf-files xorg-proto-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:       Enlightened terminal emulator
Name:          eterm
Version:       0.9.6
Release:       alt2_37
License:       BSD
Source0:       http://www.eterm.org/download/Eterm-%{version}.tar.gz
Source1:       http://www.eterm.org/download/Eterm-bg-%{version}.tar.gz
Source2:       eterm.png
Patch0:        eterm-0.9.6-gcc10.patch
Patch1:        eterm-0.9.6-gcc14.patch
Patch2:        https://sources.debian.org/data/main/e/eterm/0.9.6-7.1/debian/patches/fix-fail-to-build-with-imlib2.patch
Patch3:        eterm-0.9.6-query-graphics.patch
Patch4:        eterm-configure-c99.patch
Patch5:        eterm-c99-headers.patch
URL:           http://www.eterm.org/
Requires:      fonts-bitmap-misc
Requires:      fonts-bitmap-75dpi
Requires:      fonts-bitmap-100dpi
BuildRequires: desktop-file-utils
BuildRequires: gawk
BuildRequires: gcc
BuildRequires: glibc-core glibc-timezones glibc-utils iconv
BuildRequires: imlib2-devel
BuildRequires: libXmu-devel
BuildRequires: libast-devel
BuildRequires: sed
Provides:      Eterm = %{version}-%{release}
Obsoletes:     Eterm <= 0.9.2
Source44: import.info
%description
Eterm is a color vt102 terminal emulator with enhanced graphical
capabilities.  Eterm is intended to be a replacement for xterm for
Enlightenment window manager users, but it can also be used as a
replacement for xterm by users without Enlightenment.  Eterm supports
various themes and is very configurable, in keeping with the
philosophy of Enlightenment.

%prep
%setup -q -a 1 -n Eterm-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

for f in ChangeLog ; do
    mv $f $f.iso88591
    iconv -o $f -f iso88591 -t utf8 $f.iso88591
    rm -f $f.iso88591
done

%build
export PERL=/usr/bin/perl
%configure --enable-multi-charset \
           --enable-escreen       \
           --enable-auto-encoding \
           --enable-trans         \
           --disable-etwin        \
           --disable-mmx          \
           --disable-rpath
sed -i -e 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i -e 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
%make_build

%install
%makeinstall_std

echo -e "[Desktop Entry]
Encoding=UTF-8
Name=Eterm
TryExec=Eterm
Exec=Eterm
Icon=eterm
Type=Application
Categories=Utility;TerminalEmulator;System;" > eterm.desktop

install -D -m 0644 eterm.desktop             \
  %{buildroot}%{_datadir}/applications/eterm.desktop
desktop-file-install --delete-original       \
  --dir %{buildroot}%{_datadir}/applications \
  %{buildroot}%{_datadir}/applications/eterm.desktop
install -D -m 0644 %{SOURCE2} %{buildroot}%{_datadir}/pixmaps/eterm.png
rm -f %{buildroot}/%{_libdir}/libEterm.{a,la,so}

%files
%doc --no-dereference LICENSE
%doc doc/Eterm_reference.html doc/Eterm.tcap 
%doc doc/Eterm.ti doc/README.Escreen
%doc README ReleaseNotes ReleaseNotes.1 ChangeLog
%{_bindir}/Esetroot
%{_bindir}/Etbg
%{_bindir}/Etbg_update_list
%{_bindir}/Etcolors
%{_bindir}/Eterm
%{_bindir}/Etsearch
%{_bindir}/Ettable
%{_bindir}/kEsetroot
%{_libdir}/libEterm-%{version}.so
%{_mandir}/man1/Eterm.1*
%{_datadir}/Eterm
%{_datadir}/applications/eterm.desktop
%{_datadir}/pixmaps/eterm.png

%changelog
