Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/doxygen /usr/bin/sqlite3 gcc-c++
# END SourceDeps(oneline)
%define fedora 34
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           eurephia
Version:        1.1.1
Release:        alt1_7%{?betatag:.%{betatag}}
Summary:        An advanced and flexible OpenVPN user authentication plug-in

License:        GPLv2
URL:            http://www.eurephia.net/
Source0:        http://downloads.sourceforge.net/project/eurephia/eurephia/v1.1/%{name}-%{version}%{?betatag:_%{betatag}}.tar.xz
Patch0:         0001-Fix-GCC-10-compiler-issues-fcommon-and-fPIC.patch

BuildRequires:  libxml2-devel libxslt-devel libssl-devel
%if 0%{?rhel} > 5
BuildRequires:  ccmake cmake ctest
%endif
%if 0%{?fedora} > 28
BuildRequires:  ctest cmake
%endif
BuildRequires:  libsqlite3-devel >= 3.0.0
BuildRequires:  openvpn-devel
BuildRequires:  gcc
BuildRequires:  libssl-devel
Requires:       openvpn
Requires:       eurephia-sqlite3 = %{version}-%{release}
Source44: import.info

%description
This plug-in enhances OpenVPN by adding user name and password
authentication in addition. An eurephia user account is a combination of
minimum one OpenVPN SSL certificate and a user name with a password
assigned. It is also possible to setup several eurephia user names to use
a shared OpenVPN certificate.

In addition, eurephia will blacklist IP addresses, certificates and user names
on too many failed attempts and it supports dynamic update of iptables rules
which restricts network access per connection.

%package sqlite3
Group: Networking/WWW
Summary: The eurephia SQLite3 database driver

%description sqlite3
This package contains the SQLite3 database driver for eurephia

%package admin
Group: Networking/WWW
Summary: The eurephia command line administration utility
Requires: eurephia-sqlite3 = %{version}-%{release}

%description admin
This package contains the command line utility to administer and configure
eurephia

%package init
Group: Networking/WWW
Summary: Utility for initializing a new eurephia database
Requires: eurephia-sqlite3 = %{version}-%{release}

%description init
This package provides a program which will initialize the eurephia
database for you.  It will guide you through several questions and
save the configuration in the database.  When you have configured
and initialized eurephia, this package should be removed from the
system.

%package utils
Group: Networking/WWW
Summary: Misc. eurephia utilities

%description utils
This package contains useful utilities when debugging eurephia.
At the moment you will only find eurephia_saltdecode in this
package, which will provide some information about the password
hash salt.


%prep
%setup -q -n %{name}-%{version}%{?betatag:_%{betatag}}
%patch0 -p1

%build
%if 0%{?rhel} > 5
%define cmake_bin cmake3
%endif
%if 0%{?fedora} > 28
%define cmake_bin cmake
%endif

# The configure script is not an autotools script, but a cmake wrapper script.
CFLAGS="%{optflags} -std=gnu89" ./configure --prefix %{_prefix} --bin-dir %{_bindir} --xslt-path %{_datadir}/eurephia/xslt --plug-in-dir %{_libdir}/eurephia --plug-in --openvpn-src /usr/include --fw-iptables --db-sqlite3 --sqlite3-path %{_localstatedir}/lib/eurephia --eurephiadm --cmake-bin %{cmake_bin}

# We need to build eurephiacommon first, to avoid issues with parallel building
# the rest of eurephia
make VERBOSE=1 eurephiacommon
make VERBOSE=1

%install
make install DESTDIR=%{buildroot}

# Move the eurephia-auth.so file to the default OpenVPN plug-in directory
mkdir -p -m 755 %{buildroot}/%{_libdir}/openvpn
mv %{buildroot}/%{_libdir}/eurephia/eurephia-auth.so %{buildroot}/%{_libdir}/openvpn/

# These files are not installed by default, but we want to package them for Fedora/RHEL
install -p -m 755 utils/eurephia_init %{buildroot}/%{_bindir}
install -p -m 755 utils/eurephia_saltdecode %{buildroot}/%{_bindir}
install -p -m 644 utils/eurephia_init.7 %{buildroot}/%{_mandir}/man7/
install -p -m 644 utils/eurephia_saltdecode.7 %{buildroot}/%{_mandir}/man7/
mkdir -p %{buildroot}/%{_var}/lib/eurephia

%files
%doc LICENSE.txt CREDITS.txt
%{_libdir}/openvpn/eurephia-auth.so
%{_mandir}/man7/eurephia-auth.7*
%{_mandir}/man7/eurephia-variables.7*
%{_libdir}/eurephia/efw-iptables.so

%files sqlite3
%doc LICENSE.txt CREDITS.txt
%dir %{_libdir}/eurephia/
%{_libdir}/eurephia/edb-sqlite.so
%{_localstatedir}/lib/eurephia/
%{_mandir}/man7/edb-sqlite.7*

%files init
%doc LICENSE.txt CREDITS.txt
%{_bindir}/eurephia_init
%{_mandir}/man7/eurephia_init.7*

%files admin
%doc LICENSE.txt CREDITS.txt
%{_bindir}/eurephiadm
%dir %{_datadir}/eurephia/
%dir %{_datadir}/eurephia/xslt
%{_datadir}/eurephia/xslt/eurephiadm
%{_mandir}/man7/eurephiadm.7*
%{_mandir}/man7/eurephiadm-*.7*

%files utils
%doc LICENSE.txt CREDITS.txt
%{_bindir}/eurephia_saltdecode
%{_mandir}/man7/eurephia_saltdecode.7*

%changelog
