Group: Networking/WWW
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           ez-ipupdate
Version:        3.0.11
Release:        alt2_0.43.b8
Summary:        Client for Dynamic DNS Services

## Note: Upstream is no longer reachable. Thanks to openSUSE and
## Debian for maintaning the code, patches have been gathered from
## there.

License:        GPLv2+
URL:            http://www.gusnet.cx/proj/ez-ipupdate/
Source0:        http://www.gusnet.cx/proj/ez-ipupdate/dist/ez-ipupdate-3.0.11b8.tar.gz

## Fedora specific patches ##
## systemd unit
Source1:        %{name}.service
# Make code and man page match.
Patch1:         %{name}-pidfile.patch
# Hopefully improve error handling.
Patch3:         %{name}-returnvalues.patch
# Remove options which conflict with the way the service is started.
Patch4:         %{name}-shortexamples.patch

## Patches from openSUSE ##
# Build fix.
Patch11:         ez-ipupdate-3.0.11b8-include.diff
# Security.
Patch12:         ez-ipupdate-format-string-vuln.patch
# Build fix.
Patch13:         ez-ipupdate-includes.patch
# Feature patch, add support for dnsexit dyndns service.
Patch14:         ez-ipupdate-dnsexit.patch
# Various fixes for configure.ac and Makefile.am
Patch15:         ez-ipupdate-fix_autofoo.patch
# Feature patch, add support for joker.com dyndns service
Patch16:         ez-ipupdate-joker_com.patch
# Do type punning via memcpy
Patch17:         ez-ipupdate-type-punning.patch
# Reduce compiler warnings.
Patch18:         ez-ipupdate-code_cleanup.patch

## Patches from Debian ##
Patch30:         http://ftp.de.debian.org/debian/pool/main/e/ez-ipupdate/ez-ipupdate_3.0.11b8-13.4.diff.gz

BuildRequires:  gcc
BuildRequires: libsystemd-devel libudev-devel systemd systemd-analyze systemd-coredump systemd-homed systemd-networkd systemd-portable systemd-services systemd-stateless systemd-sysvinit systemd-utils autoconf automake
Requires(pre):    /usr/sbin/useradd /usr/sbin/groupadd
Source44: import.info

%description
ez-ipupdate is a utility for updating DNS records at a number of
different dynamic DNS services.


%prep
%setup -q -n %{name}-%{version}b8

%patch11 -p1
%patch12 -p1
%patch13
%patch14
mv configure.in configure.ac
%patch15
%patch16
%patch17
%patch18
rm acconfig.h

%patch30 -p1

mv debian/*.8 .

# autotools stuff
patch <debian/patches/010_rebootstrap.diff -p1
# code fixes
patch <debian/patches/102_misc_crashes.diff -p1
# code fixes
patch <debian/patches/103_protocol.diff -p1
# code fixes
patch <debian/patches/104_misc_crashes.diff -p0
# text fixes
patch <debian/patches/150_cosmetic.diff -p1

%patch1 -p0

touch *.in aclocal.m4 configure
chmod +x missing
chmod a-x example*.conf

%patch3 -p0
find -name "example*" | xargs -n 1 sed -i "s@/usr/local/bin/@/usr/bin/@"
%patch4 -p0

%build
export CFLAGS="-D_FILE_OFFSET_BITS=64 $RPM_OPT_FLAGS"
autoreconf -fiv
%configure
%make_build
echo >tmpfiles.conf 'd %{_localstatedir}/run/%{name} 0755 ez-ipupd ez-ipupd -'


%install

make install DESTDIR=$RPM_BUILD_ROOT bindir=%{_sbindir}

mkdir -p $RPM_BUILD_ROOT%{_mandir}/man8
cp -p ez-ipupdate.8 $RPM_BUILD_ROOT%{_mandir}/man8

install -D -m 644 %{SOURCE1} $RPM_BUILD_ROOT%{_unitdir}/%{name}@.service

mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/cache/%{name}
> $RPM_BUILD_ROOT%{_localstatedir}/cache/%{name}/default.cache

# Make a directory for config files
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/%{name}
> $RPM_BUILD_ROOT%{_sysconfdir}/%{name}/default.conf

# Create a dedicated dir for the pid file so we can run as non-root.
mkdir -p $RPM_BUILD_ROOT/run
install -d -m 0755 $RPM_BUILD_ROOT/run/%{name}/

# Also recreate the directory if needed.
mkdir -p $RPM_BUILD_ROOT%{_tmpfilesdir}
install -m 0644 tmpfiles.conf $RPM_BUILD_ROOT%{_tmpfilesdir}/%{name}.conf
for rpm404_ghost in %{_sysconfdir}/%{name}/default.conf %{_localstatedir}/cache/%{name}/default.cache
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done





%pre
/usr/sbin/groupadd -r ez-ipupd >/dev/null 2>&1 || :
/usr/sbin/useradd -r -M -d %{_localstatedir}/cache/%{name} -g ez-ipupd \
  -s /sbin/nologin -c "Dynamic DNS Client" ez-ipupd >/dev/null 2>&1 || :

%post
%post_service %{name}@

%preun
%preun_service %{name}@

%files
%doc COPYING README example.conf example-*.conf
%attr(0644,root,root) %{_mandir}/man8/ez-ipupdate.*
%attr(0755,root,root) %{_sbindir}/ez-ipupdate
%attr(0644,root,root) %{_unitdir}/%{name}@.service
%attr(0644,root,root) %{_tmpfilesdir}/%{name}.conf
%attr(0750,root,ez-ipupd) %dir %{_sysconfdir}/%{name}
%ghost %attr(0640,root,ez-ipupd) %config(noreplace,missingok) %{_sysconfdir}/%{name}/default.conf
%attr(0755,ez-ipupd,ez-ipupd) %dir /run/%{name}/
%attr(0750,ez-ipupd,ez-ipupd) %dir %{_localstatedir}/cache/%{name}/
%ghost %attr(0640,ez-ipupd,ez-ipupd) %{_localstatedir}/cache/%{name}/default.cache


%changelog
