# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define uname   FallingTime

Name:           fallingtime
Version:        1.0.2
Release:        alt1_4
Summary:        2-player arcade game inspired by Fall Down
Group:          Games/Arcade
License:        GPLv2+
URL:            https://github.com/cxong/FallingTime
Source0:        https://github.com/cxong/FallingTime/archive/%{version}/%{uname}-%{version}.tar.gz
Patch0:         fallingtime-cmake-4.0.patch

BuildRequires:  ccmake cmake ctest
BuildRequires:  pkgconfig(sdl2)
BuildRequires:  pkgconfig(SDL2_image)
BuildRequires:  pkgconfig(SDL2_mixer)
BuildRequires:  pkgconfig(SDL2_ttf)
Source44: import.info

%description
A simple 2-player arcade game where you control a ball and fall through
gaps as long as you can.

%prep
%setup -q -n %{uname}-%{version}
%patch0 -p1


%build
%{mageia_cmake} -DDATA_DIR=%{_gamesdatadir}/%{name}/
%mageia_cmake_build

%install
# Don't use make_install, it drops all in prefix with standalone distribution layout
install -D -m755 %{_vpath_builddir}/falling_time %{buildroot}%{_gamesbindir}/%{name}

install -d %{buildroot}%{_gamesdatadir}/%{name}
cp -a data/* %{buildroot}%{_gamesdatadir}/%{name}/

install -D -m644 pkg/linux/io.github.cxong.fallingtime.desktop \
  %{buildroot}%{_datadir}/applications/io.github.cxong.%{name}.desktop
# install -D -m644 pkg/linux/fallingtime.png \
install -D -m644 data/graphics/icon.png \
   %{buildroot}%{_iconsdir}/hicolor/32x32/apps/%{name}.png

%files
%doc  COPYRIGHT README.md
%{_datadir}/applications/io.github.cxong.%{name}.desktop
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/
%{_iconsdir}/hicolor/32x32/apps/%{name}.png


%changelog
