Group: Graphical desktop/Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		fbpanel
Version:	7.0
Release:	alt3_15
Summary:	A lightweight X11 desktop panel

# %%{_bindir}/fbpanel and almost all plugins are under LGPLv2+
# Some plugins (cpu.so, pager.so, tray.so) are under GPLv2+
License:	LGPLv2+ and GPLv2+
URL:		https://github.com/aanatoly/fbpanel
Source:	https://github.com/aanatoly/fbpanel/archive/%{version}/fbpanel-%{version}.tar.gz
# Fix for gcc10 -fno-common
Patch0:     fbpanel-7.0-gcc10-fno-common.patch
# Port script to python3
Patch1:     fbpanel-7.0-script-py3.patch
# Port script to python3.10
Patch2:     fbpanel-7.0-script-py310.patch

# distro specific patches
Patch10:        fbpanel-7.0-default-config.patch
Patch11:        fbpanel-6.1-default-applications.patch

BuildRequires:  gcc
BuildRequires:  python3
BuildRequires:  gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel
BuildRequires:  pkgconfig(gdk-pixbuf-xlib-2.0)
BuildRequires:  desktop-file-utils
Requires:       xdg-utils
Source44: import.info

%description
fbpanel is a lightweight X11 desktop panel. It works with any ICCCM / NETWM 
compliant window manager such as sawfish, metacity, openbox, xfwm4, or KDE.
It features tasklist, pager, launchbar, clock, menu and systray.

%package     doc
Group: Graphical desktop/Other
Summary:   Documentation for %{name}
BuildArch: noarch

%description    doc
This subpackage contains documentation files for %{name}

%prep
%setup -q
%patch0 -p1 -b .gcc10
%patch1 -p1 -b .py3
%patch2 -p1 -b .py310
%patch10 -p1 -b .default-config
%patch11 -p1 -b .default-applications
# honor optflags
sed -i.optflags -e \
	'\@CFLAGS =@s|-Wall -Werror|%{optflags}|' \
	.config/rules.mk
# Fix path...
sed -i.path panel/panel.c \
	-e 's|LIBEXECDIR "/fbpanel/|LIBEXECDIR "/|'

LANG=C grep -rl %{_bindir}/python | \
	xargs sed -i -e 's@%{_bindir}/python$@%{_bindir}/python3@'

# preserve timestamps during install
sed -i.timstamps -e 's|install -m|install -p -m|' scripts/install.sh
# Keep timestamps more forcely!!
grep -rl -- "-m 644" | xargs sed -i -e 's|-m 644 |-p -m 644 |'
sed -i data/images/Makefile -e '\@IMAGES@s|install |install -cp -m 0644 |'

%build
# %%configure macro doesn't work
./configure \
    V=1 \
    --prefix=%{_prefix} \
    --libdir=%{_libdir}/%{name} \
    --libexecdir=%{_libexecdir}/%{name} \
    --datadir=%{_datadir}/%{name} \
    --mandir=%{_mandir}/man1
%make_build V=1


%install
make install DESTDIR=$RPM_BUILD_ROOT

# change some icon names that were also changed in the default panel config
#mv $RPM_BUILD_ROOT%{_datadir}/%{name}/images/logo.png \
#    $RPM_BUILD_ROOT%{_datadir}/%{name}/images/start-here.png
ln -sf logo.png \
	$RPM_BUILD_ROOT%{_datadir}/%{name}/images/start-here.png

mv $RPM_BUILD_ROOT%{_datadir}/%{name}/images/gnome-session-halt.png \
    $RPM_BUILD_ROOT%{_datadir}/%{name}/images/system-shutdown.png

mv $RPM_BUILD_ROOT%{_datadir}/%{name}/images/gnome-session-reboot.png \
    $RPM_BUILD_ROOT%{_datadir}/%{name}/images/system-reboot.png

# volume plugin is not working and prevents starting of fbpanel, lets remove it.
# https://sourceforge.net/tracker/?func=detail&aid=3121295&group_id=66031&atid=513125
rm $RPM_BUILD_ROOT%{_libdir}/%{name}/libvolume.so


%files
%doc --no-dereference COPYING
%doc CHANGELOG
%doc CREDITS
%doc NOTES
%doc README.md

%{_bindir}/%{name}
%dir	%{_libdir}/%{name}/
%{_libdir}/%{name}/lib*.so

%dir	%{_libexecdir}/%{name}/
%{_libexecdir}/%{name}/make_profile
%{_libexecdir}/%{name}/xlogout

%dir	%{_datadir}/%{name}/
%{_datadir}/%{name}/default
%{_datadir}/%{name}/images/
%{_datadir}/%{name}/pager

%{_mandir}/man1/%{name}.1*

%files doc
%doc www

%changelog
