Group: File tools
# BEGIN SourceDeps(oneline):
BuildRequires: libx86-devel pkgconfig(freetype2)
# END SourceDeps(oneline)
BuildRequires: termutils-devel terminfo-extra
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global udevdir %(pkg-config --variable=udevdir udev)

Name:       fbterm
Version:    1.7
Release:    alt3_33
License:    GPL-2.0-or-later
URL:        http://code.google.com/p/fbterm/
Source0:    https://github.com/fujiwarat/fbterm/releases/download/v%{version}/%{name}-%{version}.tar.gz

#Patch0:    %%{name}-1.2-kernel-header.patch
#Patch1:    %%{name}-1.3-setcap.patch
#Patch2:    %%{name}-1.4-iminput.patch
#Patch3:    %%{name}-1.6-rpmpack.patch
#Patch4:    %%{name}-1.6-el5.patch
Patch5:     %{name}-1.7-u16-build.patch

Summary:    A frame-buffer terminal emulator
Summary(zh_CN): 运行在帧缓冲的快速终端仿真器
Summary(zh_TW): 運行在frame-buffer的快速終端模擬機


BuildRequires: autoconf, automake
BuildRequires: fontconfig-devel libgpm-devel
BuildRequires: gcc-c++
BuildRequires: pkgconfig(udev)
Requires: fontconfig libfontconfig1
# ncurses-term has /usr/share/terminfo/f/fbterm
Requires: terminfo-extra
Obsoletes: fbterm-udevrules < %{version}-%{release}
Source44: import.info

%description
FbTerm is a fast terminal emulator for Linux with frame-buffer device. 
Features include: 
- mostly as fast as terminal of Linux kernel while accelerated scrolling
  is enabled on frame-buffer device 
- select font with fontconfig and draw text with freetype2, same as 
  Qt/Gtk+ based GUI apps 
- dynamically create/destroy up to 10 windows initially running default
  shell 
- record scroll back history for every window 
- auto-detect text encoding with current locale, support double width 
  scripts like  Chinese, Japanese etc 
- switch between configurable additional text encodings with hot keys
  on the fly 
- copy/past selected text between windows with mouse when gpm server 
  is running


%if 0%{?fedora} >= 9
%package udevrules
Group: File tools
Summary:    udev rules that grant regular user access
Requires:   udev

%description udevrules
Regular users might use some applications that require access to frame-buffer device.
For example, ibus-fbterm requires access to /dev/fb0.
This sub-package enables regular user for such access.
%endif

%prep

%setup -q
#%%patch0 -p0 -b .kernel-header
#%%patch1 -p0 -b .setcap
#%%patch2 -p0 -b .iminput
#%%patch3 -p0 -b .rpmpack
#%%if 0%{?fedora} >= 9
#%%else
#%%patch4 -p0 -b .el5
#%%endif
%patch5  -p1 -b .u16

%build
autoreconf -iv
%configure --disable-static --disable-rpath
%make_build

%install
# fbterm info
mkdir -p %buildroot/usr/share/terminfo/f
export TERMINFO=%buildroot/usr/share/terminfo
make DESTDIR=%{buildroot} install
chmod 755 %{buildroot}/%{_bindir}/%{name}
# fbterm info - already included in terminfo-extra
rm -f %buildroot/usr/share/terminfo/f/fbterm

%if 0%{?fedora} >= 9
%post
[ -x /sbin/setcap ] && setcap 'cap_sys_tty_config+ep' %{_bindir}/%{name} ||:
%endif

%files 
%doc AUTHORS ChangeLog COPYING README
%if 0%{?fedora} >= 9
%{_bindir}/%{name}
%else
%attr(4711,root,root) %{_bindir}/%{name}
%endif
%{_mandir}/man1/%{name}.1*

%changelog
