Epoch: 2
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3 rpm-macros-mageia-compat
BuildRequires: /usr/bin/git boost-devel boost-filesystem-devel gcc-c++ libGL-devel libGLU-devel libogg-devel pkgconfig(tinyxml2) python3-devel
# END SourceDeps(oneline)
%filter_from_requires /^python..rocket./d
%filter_from_requires /^python..PyCEGUI./d
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name and %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name fife
%define version 0.4.2
%define soname %{version}
%define libname lib%{name}%{soname}
%define develname lib%{name}-devel

%define oname fifengine

Name:		fife
Version:	0.4.2
Release:	alt9_24
Summary:	Cross-platform game creation framework
Group:		Development/Tools
License:	LGPLv2+
URL:		https://www.fifengine.net/
Source0:	https://github.com/fifengine/fifengine/archive/%{version}/%{oname}-%{version}.tar.gz
# Upstream
Patch1:		0001-removed-flags-that-are-not-supported-with-swig-4.0.patch
Patch2:		0001-remove-deprecated-getchildren.patch
# Debian
Patch51:	0004-Try-to-fix-993132-cherry-picking-upstream-patches.patch
# Others
Patch101:	fifengine-missing-includes.patch
BuildRequires:	boost-complete
BuildRequires:	ccmake cmake ctest
BuildRequires:	libfifechan-devel >= 0.1.5
BuildRequires:	pkgconfig(glew)
BuildRequires:	pkgconfig(libpng)
BuildRequires:	pkgconfig(openal)
BuildRequires:	pkgconfig(python3)
BuildRequires:	pkgconfig(sdl2)
BuildRequires:	pkgconfig(SDL2_ttf)
BuildRequires:	pkgconfig(SDL2_image)
BuildRequires:	pkgconfig(tinyxml)
BuildRequires:	pkgconfig(vorbis)
BuildRequires:	pkgconfig(xcursor)
BuildRequires:	pkgconfig(zlib)
BuildRequires:	swig
Provides:	%{name}-python = %{version}-%{release}
Provides:	python3-%{name} = %{version}-%{release}
Requires:	%{libname} = %{?epoch:%epoch:}%{version}-%{release}
Source44: import.info
Requires: python3-module-%name = %EVR

%description
FIFE is a free, open-source cross-platform game engine, written in C++,
making it highly portable (it supports Linux, Windows and Mac).

This package comes with the game engine only.
The game Unknown Horizons is one of the clients using this engine.

%package -n python3-module-%name
Group: Development/Python
Summary: python library for %name
Requires: %name = %EVR

%description -n python3-module-%name
%summary

%files -n python3-module-%name
%{python3_sitelibdir}/*


%package -n %{libname}
Summary:	Shared libs for FIFE
Group:		System/Libraries
Requires:	%{name} = %{?epoch:%epoch:}%{version}-%{release}
Conflicts:	python3-module-fife < 0.3.3-7

%description -n %{libname}
Shared libs for FIFE.

%package -n %{develname}
Summary:	Development package for FIFE
Group:		Development/C++
Requires:	%{libname} = %{?epoch:%epoch:}%{version}-%{release}
Provides:	%{name}-devel = %{version}-%{release}
Obsoletes:	%{name}-devel < %{version}-%{release}
Conflicts:	python3-module-fife < 0.3.3-7

%description -n %develname
Files for development with FIFE.

%prep
%setup -q -n %{oname}-%{version}
%patch1 -p1
%patch2 -p1
%patch51 -p1
%patch101 -p1


# Fix libdir
sed -i CMakeLists.txt -e 's@\${CMAKE_INSTALL_PREFIX}/lib@\${CMAKE_INSTALL_PREFIX}/%{_lib}@'

%build

%ifarch armv7hl
# Try to avoid memory exhaustion
export CFLAGS="%optflags -g1"
export CXXFLAGS="%optflags -g1"
%endif

%{mageia_cmake} \
	-DPYTHON_SITE_PACKAGES=%{python3_sitelibdir} \
	-DPYTHON_EXECUTABLE="%__python3" \
	-Dbuild-library=ON \
	-Dbuild-python=ON \
	-Drend-camzone=ON \
	-Drend-grid=ON \
	-Duse-githash=OFF \
%ifarch armv7hl
	-DCMAKE_BUILD_TYPE=Release \
%endif

%mageia_cmake_build -j1

%install
%mageia_cmake_install

%files
%doc AUTHORS CHANGELOG.md LICENSE.md README.md

%files -n %{libname}
%{_libdir}/lib%{name}.so.%{version}

%files -n %{develname}
%{_libdir}/lib%{name}.so
%{_includedir}/%{name}/


%changelog
