Group: Publishing
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           figtoipe
Version:        20091205
Release:        alt2_34
Summary:        FIG to IPE conversion tool
#
# GPLv2, with an exception for the CGAL libraries.
# Automatically converted from old format: GPLv2+ with exceptions - review is highly recommended.
License:        LicenseRef-Callaway-GPLv2+-with-exceptions
#
URL:            http://ipe7.sourceforge.net/
Source0:        http://downloads.sourceforge.net/ipe7/tools/%{name}-%{version}.tar.gz
Source1:        http://www.gnu.org/licenses/gpl-2.0.txt
BuildRequires:  gcc-c++
BuildRequires:  perl-devel
BuildRequires:  zlib-devel
Source44: import.info

%description
Figtoipe is a program that reads FIG files (as generated by
xfig) and generates an XML file readable by the Ipe editor.

%prep
%setup -q
sed -i -e 's/\r//' README figtoipe.cpp
chmod a-x README figtoipe.cpp

# extract the changelog from figtoipe.cpp
perl -ne 'if(m|\* Changes| .. m|\*/|) { m| \* (.*)| && print "$1\n";}' < figtoipe.cpp > CHANGES
# extract the license terms from figtoipe.cpp
perl -ne 'if(m|This file| .. m| USA.$|) { print;}' < figtoipe.cpp > LICENSE

cp %{SOURCE1} .

%build
g++ %{optflags} -o figtoipe figtoipe.cpp %{?__global_ldflags} -lz

%install
mkdir -p %{buildroot}%{_bindir} %{buildroot}%{_mandir}/man1
install -pm0755 figtoipe %{buildroot}%{_bindir}
install -pm0644 figtoipe.1 %{buildroot}%{_mandir}/man1

%files
%doc CHANGES gpl-2.0.txt LICENSE README
%{_bindir}/figtoipe
%{_mandir}/man1/figtoipe.1*

%changelog
