Group: System/Kernel and hardware
%define oldname atmel-firmware
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define usb_version 0.1

Name:           firmware-atmel-at76c50x
Version:        1.3
Release:        alt1_35
Summary:        Firmware for Atmel at76c50x wireless network chips

License:        LicenseRef-Fedora-Firmware
URL:            http://at76c503a.berlios.de/
Source0:        http://www.thekelleys.org.uk/atmel/atmel-firmware-%{version}.tar.gz
Source1:        http://download.berlios.de/at76c503a/at76_usb-firmware-%{usb_version}.tar.gz

BuildArch:      noarch
BuildRequires:  xz
Source44: import.info

%description
The drivers for Atmel at76c50x wireless network chips in the Linux kernel
but do not include the firmware.
This firmware needs to be loaded by the host on most cards using these chips.


%prep
%setup -n %{oldname}-%{version} -q 
%setup -n %{oldname}-%{version} -q -D -T -a 1 
install -pm 0644 at76_usb-firmware-%{usb_version}/COPYRIGHT COPYRIGHT-usb
install -pm 0644 at76_usb-firmware-%{usb_version}/README README-usb

%build
# Nothing to build

%install
mkdir -p $RPM_BUILD_ROOT/lib/firmware

install -pm 0644 images/*.bin $RPM_BUILD_ROOT/lib/firmware
install -pm 0644 at76_usb-firmware-%{usb_version}/*.bin $RPM_BUILD_ROOT/lib/firmware
xz -C crc32 $RPM_BUILD_ROOT/lib/firmware/atmel*


%files
%doc --no-dereference COPYING COPYRIGHT-usb
%doc README README-usb
/lib/firmware/*xz


%changelog
