Group: System/Kernel and hardware
%define oldname midisport-firmware
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		firmware-midisport
Version:	1.2
Release:	alt2_37
Summary:	Firmware for the M-Audio/Midiman USB MIDI and Audio devices
License:	LicenseRef-Fedora-Firmware
URL:		http://usb-midi-fw.sourceforge.net/
Source0:	http://downloads.sourceforge.net/usb-midi-fw/midisport-firmware-%{version}.tar.gz
Patch0:		midisport-firmware-1.2-udev-attrs.patch
BuildArch:	noarch
Requires:	fxload
BuildRequires:	libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd
Source44: import.info

%description
This package contains the firmware for M-Audio/Midiman USB MIDI & Audio devices.

Supported devices:
 - MidiSport 1x1
 - MidiSport 2x2
 - MidiSport 4x4
 - MidiSport 8x8
 - MidiSport Uno
 - Keystation
 - Oxygen
 - Radium

(You do not need a firmware download for the USB Audio Quattro, Duo, or
MidiSport 2x4.)


%prep
%setup -n %{oldname}-%{version} -q
%patch0 -p1


%build
sed -i -e 's|@fxload@|/sbin/fxload|g' -e 's|@firmwaredir@|/lib/firmware|g' 42-midisport-firmware.rules.in

%install
mkdir -p $RPM_BUILD_ROOT/lib/firmware
install -pm 0644 *.ihx $RPM_BUILD_ROOT/lib/firmware

mkdir -p $RPM_BUILD_ROOT%{_udevrulesdir}
install -pm 0644 42-midisport-firmware.rules.in $RPM_BUILD_ROOT/%{_udevrulesdir}/42-midisport-firmware.rules

%files
%doc LICENSE README Changelog
/lib/firmware/MidiSport1x1.ihx
/lib/firmware/MidiSport2x2.ihx
/lib/firmware/MidiSport4x4.ihx
/lib/firmware/MidiSportKS.ihx
/lib/firmware/MidiSportLoader.ihx
/lib/firmware/MidiSport8x8-2.10.ihx
/lib/firmware/MidiSport8x8-2.21.ihx
%config %{_udevrulesdir}/42-midisport-firmware.rules

%changelog
