Group: System/Servers
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           fishpoll
Version:        0.1.7
Release:        alt1_14
Summary:        Daemon and Client to run scripts when triggered from the network

License:        GPLv2+
URL:            http://git.fishsoup.net/cgit/fishpoll/tree/README
Source0:        http://git.fishsoup.net/cgit/%{name}/snapshot/%{name}-%{version}.tar.gz
Source1:        fishpolld.service
Source2:        %{name}_file_sample
Source3:        fishpolld.1
Source4:        fishpoke.1
Patch0:         01-python-runtime-binary.patch
BuildArch:      noarch

BuildRequires:  python-devel
%if 0%{?fedora} >= 15
%else
%endif

Requires:       fishpolld = %{version}-%{release}
Requires:       fishpoke = %{version}-%{release}
Source44: import.info

%description
Daemon and Client files that allows scripts to be run remotely when
triggered from the network.

%package -n fishpolld
Group: System/Servers
Summary: Daemon to run scripts when triggered from the network
%description -n fishpolld
%{summary}.

%package -n fishpoke
Group: System/Base
Summary: Client programs for fishpolld server
%description -n fishpoke
Client for the Fishpoll server. The fishpoke program is used to
trigger a poll immediately instead of waiting for the configured
polling interval.

%prep
%setup -q -n %{name}-%{version}

%if 0%{?fedora} >= 30
%patch0 -p0
%endif

%build

%install
make install DESTDIR=%{buildroot}

install -Dp -m0644 %{SOURCE2} %{buildroot}%{_sysconfdir}/%{name}.d/%{name}_file_sample
install -Dp -m0644 %{SOURCE3} %{buildroot}%{_mandir}/man1/fishpolld.1
install -Dp -m0644 %{SOURCE4} %{buildroot}%{_mandir}/man1/fishpoke.1

%if 0%{?fedora} >= 15
install -Dp -m0644 %{SOURCE1} %{buildroot}%{_unitdir}/fishpolld.service
rm %{buildroot}%{_sysconfdir}/init.d/%{name}
%else
mkdir -p %{buildroot}%{_initrddir}/
mv %{buildroot}%{_sysconfdir}/init.d/%{name} %{buildroot}%{_initrddir}/
%endif


%files


%files -n fishpolld
%doc COPYING README
%{_sbindir}/fishpolld
%dir %{_sysconfdir}/%{name}.d
%config %{_sysconfdir}/%{name}.d/%{name}_file_sample
%{_mandir}/man1/fishpolld.1*

%if 0%{?fedora} >= 15
%{_unitdir}/fishpolld.service
%else
%{_initrddir}/%{name}
%endif


%files -n fishpoke
%doc COPYING README
%{_bindir}/fishpoke
%{_mandir}/man1/fishpoke.1*

%post
%if 0%{?fedora} >= 15
if [ $1 -eq 1 ] ; then
    /bin/systemctl daemon-reload >/dev/null 2>&1 || :
fi
%else
/sbin/chkconfig --add fishpoll
%endif


%preun
%if 0%{?fedora} >= 15
if [ $1 -eq 0 ] ; then
    # Package removal, not upgrade
    /bin/systemctl --no-reload disable fishpolld.service > /dev/null 2>&1 || :
    /bin/systemctl stop fishpolld.service > /dev/null 2>&1 || :
fi
%else
if [ $1 -eq 0 ] ; then
   /sbin/service fishpoll stop > /dev/null 2>&1 ||:
   /sbin/chkconfig --del fishpoll
fi
%endif


%postun
%if 0%{?fedora} >= 15
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
if [ $1 -ge 1 ] ; then
    # Package upgrade, not uninstall
    /bin/systemctl try-restart fishpolld.service >/dev/null 2>&1 || :
fi
%else
if [ $1 -ge 1 ] ; then
   /sbin/service fishpoll condrestart >/dev/null 2>&1 ||:
fi
%endif

%changelog
