# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define version 0.8.2
%define oversion %(echo %{version} | tr . -)

Name:           fizmo
Summary:        A Z-Machine interpreter supporting unicode, sound, blorbfile and more
Version:        0.8.2
Release:        alt1_5
License:        BSD
Group:          Games/Adventure
URL:            https://fizmo.spellbreaker.org
Source0:        https://github.com/chrender/fizmo/releases/download/%{name}_%{oversion}/%{name}-%{version}.tar.gz

BuildRequires:  pkgconfig(freetype2)
BuildRequires:  pkgconfig(libjpeg)
BuildRequires:  pkgconfig(libpng)
BuildRequires:  pkgconfig(libxml-2.0)
BuildRequires:  pkgconfig(ncursesw)
BuildRequires:  pkgconfig(sdl2)
BuildRequires:  pkgconfig(sndfile)
BuildRequires:  pkgconfig(x11)
BuildRequires:  xsltproc
Source44: import.info

# TODO: Package and unbundle Fira Sans and Fira Mono fonts

%description
Fizmo is a Z-Machine interpreter. That means it allows you to play interactive
fiction, also know as text adventures, which were implemented either by Infocom
or created using the Inform compiler. It is a console-based interpreter,
meaning that there is no graphical user interface, and works with all Z-machine
versions except version 6.

%prep
%setup -q

%build
%configure prefix=%{_prefix} bindir=%{_gamesbindir}
%make_build

# generate docs
cd doc
sh create-txts.sh

%install
%makeinstall_std

cd %{buildroot}%{_gamesbindir}
ln -s fizmo-ncursesw fizmo
cd %{buildroot}%{_mandir}/man6/
ln -s fizmo-ncursesw.6.xz fizmo.6.xz

%files
%doc CHANGELOG.txt COPYRIGHT.txt QUICKSTART.txt README.txt user-config-example.txt
%{_mandir}/man6/%{name}*
%{_gamesbindir}/%{name}
%{_gamesbindir}/%{name}-console
%{_gamesbindir}/%{name}-ncursesw
%{_gamesbindir}/%{name}-sdl2
%dir %{_datadir}/%{name}
# TODO: Unbundle!
%{_datadir}/%{name}/fonts/
%lang(de) %{_datadir}/%{name}/locales/de_DE/*
%lang(en) %{_datadir}/%{name}/locales/en_US/*
%lang(fr) %{_datadir}/%{name}/locales/fr_FR/*
%{_datadir}/%{name}/locales


%changelog
