# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global sum     Flukz is an editor and player of shoot'em up video games

Name:           flukz
Version:        0.4
Release:        alt1_9
Summary:        %{sum}
Group:          Games/Arcade
License:        GPLv2+
URL:            https://flukz.org/wiki/doku.php?id=flukz
Source0:        https://download.tuxfamily.org/flukz/%{name}%{version}.tar.gz
Patch1:         flukz-0.4-gcc7.patch

BuildRequires:  icoutils
BuildRequires:  qt4-devel
Requires:       pulseaudio
Source44: import.info

%description
Flukz is an editor of shoot'em up video games. Game levels can be created,
edited and saved online using a wiki interface, without particular need of
programmation skills. The created games are available online to all users.

%prep
%setup -q -n %{name}%{version}
%patch1 -p1


%build
%qmake_qt4
%make_build

%install
# Install binary
mkdir -p %{buildroot}%{_gamesbindir}
install -m 755 bin/%{name} %{buildroot}%{_gamesbindir}

# Extract and install icon
for size in 16 32 48; do
  install -d %{buildroot}%{_iconsdir}/hicolor/${size}x${size}/apps/
  icotool -x --width=${size} images/flukz.ico -o %{buildroot}%{_iconsdir}/hicolor/${size}x${size}/apps/%{name}.png
done

# Mageia menu entry
mkdir -p %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Name=Flukz
Comment=%{sum}
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;ArcadeGame;
EOF

%files
%doc Changelog.txt License.txt
%{_datadir}/applications/%{name}.desktop
%{_gamesbindir}/%{name}
%{_iconsdir}/hicolor/*/apps/%{name}.png


%changelog
