Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: fmf
Version: 1.3.0
Release: alt1_3

Summary: Flexible Metadata Format
License: GPLv2+
BuildArch: noarch

URL: https://github.com/psss/fmf
Source0: https://github.com/psss/fmf/releases/download/%{version}/fmf-%{version}.tar.gz

# Main fmf package requires the Python module
Requires: python3-module-fmf == %{version}-%{release}
Source44: import.info

%description
The fmf Python module and command line tool implement a flexible
format for defining metadata in plain text files which can be
stored close to the source code. Thanks to hierarchical structure
with support for inheritance and elasticity it provides an
efficient way to organize data into well-sized text documents.
This package contains the command line tool.

%?python_enable_dependency_generator


%package -n python3-module-fmf
Group: Other
Summary:        %{summary}
BuildRequires: python3-devel
BuildRequires: python3-module-pkg_resources python3-module-setuptools
BuildRequires: pytest3 python3-module-pytest
BuildRequires: python3-module-ruamel-yaml
BuildRequires: python3-module-filelock
BuildRequires: python3-module-jsonschema
BuildRequires: git-core
%{?python_provide:%python_provide python3-%{name}}
Requires:       git-core

%description -n python3-module-fmf
The fmf Python module and command line tool implement a flexible
format for defining metadata in plain text files which can be
stored close to the source code. Thanks to hierarchical structure
with support for inheritance and elasticity it provides an
efficient way to organize data into well-sized text documents.
This package contains the Python 3 module.


%prep
%setup -q



%build
%python3_build


%install
%python3_install
mkdir -p %{buildroot}%{_mandir}/man1
install -pm 644 fmf.1* %{buildroot}%{_mandir}/man1


%check
%{__python3} -m pytest -vv -c tests/unit/pytest.ini -m 'not web'


%{!?_licensedir:%global license %%doc}

%files
%{_mandir}/man1/*
%{_bindir}/%{name}
%doc README.rst examples
%doc --no-dereference LICENSE

%files -n python3-module-fmf
%{python3_sitelibdir_noarch}/%{name}/
%{python3_sitelibdir_noarch}/%{name}-*.egg-info
%doc --no-dereference LICENSE


%changelog
