Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: perl(Encode.pm) perl(Encode/Guess.pm) perl(List/MoreUtils.pm) perl(Locale/TextDomain.pm) perl(PDF/API2.pm) perl(PDF/API2/Outlines.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           fntsample
Version:        5.4
Release:        alt1_2
Summary:        A program for making font samples that show Unicode coverage of the font

License:        GPL-3.0-or-later
URL:            https://github.com/eugmes/fntsample/releases
Source0:        https://github.com/eugmes/fntsample/archive/release/%{version}/%{name}-%{version}.tar.gz
 
BuildRequires:  gettext-tools libasprintf-devel rpm-build-perl unicode-ucd
BuildRequires:  libcairo-devel libfreetype-devel glib2-devel libgio libgio-devel
BuildRequires:  fontconfig-devel libpango-devel libpango-gir-devel
BuildRequires:  gcc ctest cmake
Requires:       perl(Locale/TextDomain.pm)
Source44: import.info

%description
A program for making font samples that show Unicode coverage of
the font and are similar in appearance to Unicode charts.
Samples can be saved as PDF or PostScript files.

%prep
%setup -q -n %{name}-release-%{version}


%build
%{fedora_v2_cmake} -DUNICODE_BLOCKS=%{_datadir}/unicode/ucd/Blocks.txt
%fedora_v2_cmake_build

%install
%fedora_v2_cmake_install

%check
ctest -V %{?_smp_flags}

%find_lang %{name}

%files -f %{name}.lang
%doc ChangeLog README.rst
%doc --no-dereference COPYING
%{_bindir}/fntsample
%{_bindir}/pdf-extract-outline
%{_bindir}/pdfoutline
%{_mandir}/man1/**

%changelog
