%define oldname fortune-shlomif
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define version 0.22.2
# Base Macros which need to be set
%define packageprefix fortune
%define packagebase shlomif
%define archivebase fortunes-shlomif
%define fortunefilesprefix shlomif-
%define rel 3

# Derived Macros
%define archivewithver %{archivebase}-%{version}
%define archivefull %{archivewithver}.tar.xz

%define fortunedatadir %{_datadir}/games/fortunes

Name: fortunes-shlomif
Version: 0.22.2
Release: alt1_%{rel}
Summary: Fortune Cookies Collection by Shlomi Fish
License: CC-BY-SA
Group: Toys
URL: https://www.shlomifish.org/humour/fortunes/
Source: https://www.shlomifish.org/humour/fortunes/%{archivefull}
BuildArch: noarch
BuildRequires: fortune
Requires: fortune
Source44: import.info


%description
This package contains several collections of fortune cookies by Shlomi Fish.
Namely, a collection of his own quotes, some of his favorites from various
sources; a collection of excerpts from the T.V. Show Friends; the Rules of
Open Source Programming, a collection of reasons why there is no IGLU
cabal, some logs of IRC conversations, some quotes from some web sites
about software management, and a collection of factoids about people
and things.

%prep
%setup -n %{archivewithver} -q
cat <<EOF > README
This is a group of fortune files collected by Shlomi Fish.
EOF

%build

myprefix="%{fortunefilesprefix}"
rm -f *.dat
ls | grep -v "\\." | grep -v "[[:upper:]]" | \
    ( while read T ; do \
        mv "$T" "${myprefix}$T" ; \
        /usr/bin/strfile "${myprefix}$T" "${myprefix}$T.dat" ; \
        done \
    )

%install

mkdir -p %{buildroot}%{fortunedatadir}
for I in *.dat ; do \
    cp $I "`echo "$I" | sed 's/\.dat$//'`" \
        %{buildroot}%{fortunedatadir} ; \
done

%files
%{fortunedatadir}/*
%doc README


%changelog
