# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           freetumble
Version:        1.1
Release:        alt1_6
Summary:        Colourful puzzle game with three game modes
Group:          Games/Arcade
License:        GPLv3+ and CC-BY-SA and CC-BY
URL:            https://github.com/akien-mga/freetumble
Source0:        https://github.com/akien-mga/freetumble/archive/%{version}/%{name}-%{version}.tar.gz
Patch0:		0001-Fix-build-with-SFML-2.5.0.patch
BuildRequires:  cmake
BuildRequires:  pkgconfig(sfml-audio)
BuildRequires:  pkgconfig(sfml-graphics)
BuildRequires:  pkgconfig(sfml-system)
BuildRequires:  pkgconfig(sfml-window)
Source44: import.info

%description
FreeTumble is a free colourful puzzle game for Windows and Linux.
It features three game modes, with simple rules but different gameplay.

NORMAL: Click groups of 3 or more stones to make them disappear.
Each time you click a group, a new row will be added. Don't let the
stones reach the top of the grid or you're done, and make a good use
of the various bonus stones available!

MOTION: Pretty much the same as the 'Normal' game, but real time:
the new row will be added after an amount of time (decreasing as the
player level increases).

CLASSIC: Click groups of two or more stones to make them disappear.
Try to clear the entire grid to get the best score.

%prep
%setup -q
%patch0 -p1


%build
%{mageia_cmake} -DFOR_INSTALL:BOOL=ON
%mageia_cmake_build

%install
%mageia_cmake_install

%files
%doc CHANGELOG.md LICENSE.txt README.md
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/64x64/apps/%{name}.png


%changelog
