Group: Office
# BEGIN SourceDeps(oneline):
BuildRequires: boost-devel-headers
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name gappa
%global _docdir_fmt %{name}

Name:		gappa
Version:	1.4.2
Release:	alt1_3
Summary:	Prove programs with floating-point or fixed-point arithmetic

License:	GPL-3.0-only OR CECILL-2.1
URL:		https://gappa.gitlabpages.inria.fr/
Source0:	https://gappa.gitlabpages.inria.fr//releases/%{name}-%{version}.tar.gz

# See https://fedoraproject.org/wiki/Changes/EncourageI686LeafRemoval
ExcludeArch:    %{ix86}

BuildRequires:	bison
BuildRequires:	boost-complete
BuildRequires:	flex
BuildRequires:	gcc-c++
BuildRequires:	libgmp-devel libgmpxx-devel
BuildRequires:	libmpfr-devel
BuildRequires:	python3-module-sphinx python3-module-sphinx-sphinx-build-symlink
BuildRequires:	remake
Source44: import.info

%description
Gappa is a tool intended to help verifying and formally prove
properties on numerical programs and circuits handling floating-point
or fixed-point arithmetic.  This tool manipulates logical formulas
stating the enclosures of expressions in some intervals.  Through the
use of rounding operators as part of the expressions, Gappa is specially
designed to deal with formulas that could appear when certifying numerical
codes. In particular, Gappa makes it simple to bound computational errors
due to floating-point arithmetic.  The tool and its documentation were
written by Guillaume Melquiond.

%package doc
Group: Office
Summary:	Documentation for gappa
BuildArch:	noarch
# In addition to the project license, the Javascript and CSS bundled with the
# documentation has the following licenses:
# - searchindex.js: BSD-2-Clause
# - _static/_sphinx_javascript_frameworks_compat.js: BSD-2-Clause
# - _static/alabaster.css: BSD-3-Clause
# - _static/basic.css: BSD-2-Clause
# - _static/custom.css: BSD-3-Clause
# - _static/doctools.js: BSD-2-Clause
# - _static/documentation_options.js: BSD-2-Clause
# - _static/file.png: BSD-2-Clause
# - _static/jquery*.js: MIT
# - _static/language_data.js: BSD-2-Clause
# - _static/minus.png: BSD-2-Clause
# - _static/plus.png: BSD-2-Clause
# - _static/searchtools.js: BSD-2-Clause
# - _static/underscore*.js: MIT
License:	(GPL-3.0-only OR CECILL-2.1) AND MIT AND BSD-2-Clause AND BSD-3-Clause

%description doc
Documentation for gappa.

%prep
%setup -q


# Increase the test timeout for ARM
sed -i 's/timeout 5/&0/' Remakefile.in

%build
%configure
# Use the system remake
rm -f remake
ln -s %{_bindir}/remake remake
remake -d %{?_smp_mflags}
remake -d doc/html/index.html
rm doc/html/.buildinfo

%install
DESTDIR=%{buildroot} remake install

%check
remake check

%files
%{_bindir}/gappa
%doc README.md NEWS.md
%doc --no-dereference COPYING COPYING.GPL

%files doc
%doc AUTHORS doc/html

%changelog
