Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/gauche-cesconv /usr/bin/gauche-install /usr/bin/gauche-package /usr/bin/gosh /usr/bin/xvfb-run imake xorg-cf-files
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global gauche_main_version 0.97

%global snapshot_date 20181110
%global git_sha       0220722c44ef85f2e1b9b14745702c1b923258e8
%global git_revision  %(c=%{git_sha}; echo ${c:0:7})
%global alphatag      %{snapshot_date}git%{git_revision}

Name:           gauche-gtk
Epoch:          1
Version:        0.6
Release:        alt3_0.28.%{alphatag}
Summary:        Gauche extension module to use GTK

License:        BSD
URL:            http://practical-scheme.net/
Source0:        https://github.com/shirok/Gauche-gtk2/archive/%{git_sha}.tar.gz#/%{name}-%{version}-%{git_revision}.tar.gz
Patch0:         https://sources.debian.org/data/main/g/gauche-gtk/0.6+git20160927-3/debian/patches/00_no_path_xtra.patch
Patch1:         https://sources.debian.org/data/main/g/gauche-gtk/0.6+git20160927-3/debian/patches/05_install_755.patch
Patch2:         https://sources.debian.org/data/main/g/gauche-gtk/0.6+git20160927-3/debian/patches/06_gdk_pixbuf.patch
Patch3:         https://sources.debian.org/data/main/g/gauche-gtk/0.6+git20160927-3/debian/patches/07-HUGE.patch
Patch4:         https://sources.debian.org/data/main/g/gauche-gtk/0.6+git20160927-3/debian/patches/08-configure-ac-fix.patch
Patch5:         https://sources.debian.org/data/main/g/gauche-gtk/0.6+git20160927-3/debian/patches/09-gen-gpd-fix.patch

BuildRequires:  gcc
BuildRequires:  gauche-devel
BuildRequires:  gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel
BuildRequires:  libgtkglext-devel
BuildRequires:  libX11-devel
BuildRequires:  libXt-devel
BuildRequires:  libICE-devel
BuildRequires:  autoconf
# used in test
BuildRequires:  gauche-gl
BuildRequires:  xorg-xvfb xvfb-run xauth

Requires:       gauche-gl
Source44: import.info


%description
Gauche extension module to use GTK.


%package devel
Group: Development/Other
Summary:        Development files for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}

%description devel
Development files for %{name}.


%prep
%setup -q -n Gauche-gtk2-%{git_sha}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

autoconf


%build
%configure --enable-gtkgl --enable-glgd --enable-glgd-pango
%make_build stubs
%make_build OPTFLAGS=


%install
mkdir -p %{buildroot}`gauche-config --syslibdir`
mkdir -p %{buildroot}`gauche-config --sysarchdir`
make install DESTDIR=%{buildroot}
find %{buildroot} -name '*.so' -exec chmod 0755 '{}' ';'
chmod -c 644 */*.c # for debuginfo


%check
# 'make check' does not set return code properly, but
# outputs to test.log
xvfb-run -a -w 1 %make_build check
# Gtk test currently fails.
# four known failures reported upstream; fail if more failures occur
# https://github.com/shirok/Gauche-gtk2/issues/2
[ $(grep " ==> ERROR: GOT " src/test.log | wc -l) -le 4 ]



%files
%doc README VERSION examples
%doc --no-dereference COPYING
%{_libdir}/gauche-%{gauche_main_version}/site/*/*.so
%{_datadir}/gauche-%{gauche_main_version}/site/lib/.packages/Gauche-gtk2.gpd
%{_datadir}/gauche-%{gauche_main_version}/site/lib/gtk.scm
%{_datadir}/gauche-%{gauche_main_version}/site/lib/gtk
%{_datadir}/gauche-%{gauche_main_version}/site/lib/h2s


%files devel
%{_libdir}/gauche-%{gauche_main_version}/site/include/*


%changelog
