# BEGIN SourceDeps(oneline):
BuildRequires: glib-devel pkgconfig(glib)
# END SourceDeps(oneline)
Name:           gdome2
Version:        0.8.1
Release:        alt1_11
Summary:        DOM level 2 library for accessing XML files

Group:          System/Libraries
License:        LGPLv2+
URL:            http://gdome2.cs.unibo.it/
Source:         http://gdome2.cs.unibo.it/tarball/%{name}-%{version}.tar.gz
Patch0:         %{name}-destdir.patch

BuildRequires:  libxml2-devel >= 2.4.26
BuildRequires:  glib2-devel >= 2.2.0
Source44: import.info

%description 
gdome2 is a fast, light and complete DOM level 2 implementation based
on libxml2. Although it has been written for the GNOME project, it can
be used stand-alone.  A DOM implementation (also called a host
implementation) is what makes a parsed XML or HTML document available
for processing via the DOM interface.  gdome2 currently supports the
"Core", "XML", "Events" and "MutationEvents" modules from the DOM 2
Recommendation (see http://www.w3.org/TR/DOM-Level-2-Core/ and
http://www.w3.org/TR/DOM-L evel-2-Events/), and is supposed to become
a full implementation of all the DOM Level 2 standard.  Now gdome2
also partially supports the XPath module from the DOM level 3 drafts.

%package        devel
Summary:        Development files for gdome2
Group:          Development/C
Requires:       %{name} = %{version}-%{release}

%description    devel
%%{summary}.


%prep
%setup -q
%patch0 -p0


%build
export LDFLAGS="-L%{_libdir}" # fix linkage on lib64 archs
export GLIB_CONFIG="pkg-config glib-2.0" # to fix gdome-config(1)
%configure --disable-static
make %{?_smp_mflags}


%install
make install DESTDIR=$RPM_BUILD_ROOT
rm $RPM_BUILD_ROOT%{_libdir}/libgdome.la


%check
# xpath check dumps core on FC4 with libxml2 2.6.19
if [ "`(xml2-config --version)`" = "2.6.19" ] ; then
  make check || :
else
  make check
fi


%files
%doc AUTHORS ChangeLog COPYING.LIB MAINTAINERS README
%{_libdir}/libgdome.so.*

%files devel
%doc %{_datadir}/gtk-doc/
%{_bindir}/gdome-config
%{_includedir}/libgdome/
%{_libdir}/libgdome.so
%{_libdir}/gdomeConf.sh
%{_datadir}/aclocal/gdome2.m4
%{_libdir}/pkgconfig/gdome2.pc
%{_mandir}/man1/gdome-config.1*


%changelog
