# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: libGL-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           gds2pov
Version:        0.20080229
Release:        alt1_18
Summary:        GDS2 layout file to POV-Ray conversion

Group:          Engineering
License:        GPLv2
URL:            http://www.atchoo.org/gds2pov/
Source0:        http://www.atchoo.org/gds2pov/files/gdsto3d-20080229.tar.bz2

# Fix an invalid fprintf
Patch0:         0001-Fix-invalid-fprintf.patch
# Hack to add -lX11 to linker
Patch1:         0002-Hack-Add-lX11-to-linker.patch

BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires:  libX11-devel libGLU-devel ctest cmake
Source44: import.info


%description
GDS2POV is a program to take a GDS2 layout file
and output a POV-Ray scene description file of
the GDS2 data. This allows the creation of
attractive 3D pictures of a layout.

GDS2POV is mostly used by VLSI designers.


%package devel
Summary:         Development files for the GDS2POV
Group:           Development/Other
Requires:        %{name} = %{version}-%{release}


%description devel
Development files for GDS2POV


%prep
%setup -q -n gdsto3d-20080229
%patch0 -p1
%patch1 -p1

%build
cd build

%{fedora_cmake} ..
make %{?_smp_mflags} VERBOSE=1


%install
cd build
make INSTALL="install -p" install DESTDIR=%{buildroot}

rm -rf %{buildroot}%{_datadir}/gdsto3d/
cd ..

%files
%doc AUTHORS todo.txt readme.txt changes.txt
%doc --no-dereference COPYING
%doc example_config.txt example.gds example_process.txt example.cmd
%{_bindir}/%{name}
%{_bindir}/gds2svg
%{_bindir}/gdsoglviewer
%{_libdir}/libgdsto3d.so.*


%files devel
%{_libdir}/libgdsto3d.so


%changelog
