# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define version 5.0.741.0
%global debug_package %{nil}

%define oname	GeoGebra-Linux-Portable
%define url_ver	%(echo %{version}|cut -d. -f1,2)
%define tar_ver	%(echo %{version}|sed -e 's/\\./\\-/g')

Name:		geogebra
Version:	5.0.741.0
Release:	alt1_2
Summary:	Dynamic mathematics software for learning and teaching
Group:		Sciences/Mathematics
License:	GPLv3+ and CC-BY-SA and CC-BY-NC-SA
URL:		https://www.geogebra.org/
Source0:	https://download.geogebra.org/installers/%{url_ver}/%{oname}-%{tar_ver}.tar.bz2
# (daviddavid) geogebra-installer-pack is extracted from 4.4.x.x branch
Source1:	geogebra-installer-pack.tar.gz
Patch1:		geogebra-5.0.156.0-mga-fix_java_path_and_desktop_file.patch
ExclusiveArch:	x86_64 %ix86
BuildRequires:	desktop-file-utils
BuildRequires:	javapackages-filesystem

Requires:	java >= 1.7.0
Source44: import.info

%description
This package provides GeoGebra.

GeoGebra is a multi-platform dynamic mathematics software for all
levels of education that joins geometry, algebra, tables, graphing,
statistics and calculus in one easy-to-use package. It has received
several educational software awards in Europe and the USA.

Quick Facts:

- Graphics, algebra and tables are connected and fully dynamic
- Easy-to-use interface, yet many powerful features
- Authoring tool to create interactive learning materials as web pages
- Available in many languages for our millions of users around the world

%prep
%setup -q -a 1 -T -b 0 -n %{oname}-%{tar_ver}
%patch1 -p1


rm -rf jre1.8.0_121-i686 jre1.8.0_121-x86_64
chmod 0644 geogebra.desktop

%build

%install
# startscript
mkdir -p %{buildroot}%{_bindir}
install -m 0755 geogebra/geogebra %{buildroot}%{_bindir}/%{name}

# .jar-repertory
mkdir -p %{buildroot}%{_javadir}/%{name}
install -m 0644 geogebra/*.jar %{buildroot}%{_javadir}/%{name}/

# mime packages-repertory
mkdir -p %{buildroot}%{_datadir}/mime/packages
install -m 0644 geogebra.xml %{buildroot}%{_datadir}/mime/packages/%{name}.xml

# desktop menu-entry
mkdir -p %{buildroot}%{_datadir}/applications
desktop-file-install \
	--dir=%{buildroot}%{_datadir}/applications/ \
	%{name}.desktop

# icons-repertory .png
for SIZE in 16x16 22x22 32x32 48x48 64x64 128x128 256x256; do
  mkdir -p %{buildroot}%{_iconsdir}/hicolor/$SIZE/apps
  mkdir -p %{buildroot}%{_iconsdir}/hicolor/$SIZE/mimetypes
  install -m 0644 icons/hicolor/$SIZE/apps/geogebra.png %{buildroot}%{_iconsdir}/hicolor/$SIZE/apps/
  install -m 0644 icons/hicolor/$SIZE/mimetypes/*.png %{buildroot}%{_iconsdir}/hicolor/$SIZE/mimetypes/
done

# icons-repertory .svgz
mkdir -p %{buildroot}%{_iconsdir}/hicolor/scalable/apps
mkdir -p %{buildroot}%{_iconsdir}/hicolor/scalable/mimetypes
install -m 0644 icons/hicolor/scalable/apps/geogebra.svgz %{buildroot}%{_iconsdir}/hicolor/scalable/apps/
install -m 0644 icons/hicolor/scalable/mimetypes/*.svgz %{buildroot}%{_iconsdir}/hicolor/scalable/mimetypes/

%files
%doc LICENSE.txt readme.txt
%{_bindir}/%{name}
%{_javadir}/%{name}/
%{_datadir}/mime/packages/%{name}.xml
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/*/*/*.png
%{_iconsdir}/hicolor/scalable/*/*.svgz


%changelog
