# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define	major 1
%define libname libgetoptpp%{major}
%define develname libgetoptpp-devel
%define lib_name getopt_pp
%define rel 8

Summary:	Yet Another getopt C++ version, STL-streaming like
Name:		getoptpp
Version:	1
Release:	alt1_%{rel}
Group:		System/Libraries
License:	GPL
URL:		https://github.com/timstaley/getoptpp
Source0:	getopt_pp-2.18.tgz
Patch0:		getoptpp-makefile.patch
BuildRequires:	pkgconfig(libcurl)
Source44: import.info

%description
This is yet another C++ version of the getopt function, that is, for parsing
command line options and environment variables. However, unlike other versions,
the design goals of this one are:

EASY to use
EASY to learn
mimic STL's streams
minimum code to type
smooth integration with STL types
Platform independent (ANSI C++)
EASY to extend for your own types

%package -n	%{libname}
Summary:	Yet Another getopt C++ version, STL-streaming like
Group:          System/Libraries

%description -n	%{libname}
This is yet another C++ version of the getopt function, that is, for parsing
command line options and environment variables. However, unlike other versions,
the design goals of this one are:

EASY to use
EASY to learn
mimic STL's streams
minimum code to type
smooth integration with STL types
Platform independent (ANSI C++)
EASY to extend for your own types

%package -n	%{develname}
Summary:	Static library and header files for the getoptpp library
Group:		Development/C
Requires:	%{libname} = %{version}-%{release}
Provides:	%{name}-devel = %{version}-%{release}

%description -n	%{develname}
This is yet another C++ version of the getopt function, that is, for parsing
command line options and environment variables. However, unlike other versions,
the design goals of this one are:

EASY to use
EASY to learn
mimic STL's streams
minimum code to type
smooth integration with STL types
Platform independent (ANSI C++)
EASY to extend for your own types

This package contains the static libmemcache library and its
header files.

%prep

%setup -q -n  getoptpp
%patch0 -p1


%build

export CXXFLAGS="-O2 -g -pipe -Wformat -Werror=format-security -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector --param=ssp-buffer-size=4 -fasynchronous-unwind-tables -std=gnu++14"
%make_build


%install
mkdir -p %{buildroot}%{_libdir}
mkdir -p %{buildroot}%{_includedir}
%makeinstall_std PREFIX=%{buildroot} LIBDIR=%{_libdir}
pushd %{buildroot}%{_libdir}
ln -s lib%{lib_name}.so.1.0 lib%{lib_name}.so.1
ln -s lib%{lib_name}.so.1.0 lib%{lib_name}.so
#popd
# we don't want these
find %{buildroot} -name "*.la" -delete

%files -n %{libname}
%{_libdir}/lib%{lib_name}.so.%{major}
%{_libdir}/lib%{lib_name}.so.%{major}.*

%files -n %{develname}
%{_includedir}/*
%{_libdir}/lib%{lib_name}.so


%changelog
