Group: Engineering
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           gfan
Version:        0.6.2
Release:        alt1_2
Summary:        Software for Computing GrA.bner Fans and Tropical Varieties
License:        GPLv2+
URL:            http://home.math.au.dk/jensen/software/gfan/gfan.html
Source0:        http://home.math.au.dk/jensen/software/%{name}/%{name}%{version}.tar.gz
# Sent upstream 2011 Apr 27.  Fix warnings that could indicate runtime
# problems.
Patch0:         %{name}-warning.patch
# Treat plain "gfan" call as "gfan_bases" call (as done in previous versions)
# instead of warning that "gfan_bases" should be called and exiting
Patch1:         %{name}-permissive.patch

BuildRequires:  cddlib-devel
BuildRequires:  gcc-c++
BuildRequires:  ghostscript-utils
BuildRequires:  libgmp-devel libgmpxx-devel
BuildRequires:  tex(latex)
BuildRequires:  tex(ulem.sty)
BuildRequires:  TOPCOM

Requires:       TOPCOM
Source44: import.info

%description
The software computes all marked reduced GrA.bner bases of an ideal.
Their union is a universal GrA.bner basis. Gfan contains algorithms for
computing this complex for general ideals and specialized algorithms
for tropical curves, tropical hypersurfaces and tropical varieties of
prime ideals. In addition to the above core functions the package
contains many tools which are useful in the study of GrA.bner bases,
initial ideals and tropical geometry. Among these are an interactive
traversal program for GrA.bner fans and programs for graphical renderings.

%package        doc
Group: Engineering
Summary:        Gfan examples and documentation files
Requires:       %{name} = %{version}-%{release}
BuildArch: noarch

%description    doc
Gfan examples and documentation files.

%prep
%setup -q -n %{name}%{version}
%patch0
%patch1

fixtimestamp() {
  touch -r $1.orig $1
  rm -f $1.orig
}

# Fix the cddlib include paths
sed -i.orig 's,cdd/,cddlib/,' src/{app_librarytest,lp_cdd,gfanlib_zcone}.cpp
fixtimestamp src/app_librarytest.cpp
fixtimestamp src/lp_cdd.cpp
fixtimestamp src/gfanlib_zcone.cpp

# Point to where the TOPCOM binaries will be installed
sed -i.orig \
  "s|^#define MINKOWSKIPROG.*|#define MINKOWSKIPROGRAM \"%{_bindir}/essai\"|" \
  src/minkowskisum.cpp
fixtimestamp src/minkowskisum.cpp

# Update the C++ standard slightly
sed -i 's/-std=c++0x/-std=c++11/' Makefile gfanlib/Makefile.in

# No need to install a simple upstream Makefile to rsync homepage
# directory to upstream page.
rm -f homepage/Makefile

%build
%make_build CC=gcc CXX=g++ \
  OPTFLAGS="%{optflags} -DGMPRATIONAL -I%{_includedir}/cddlib" \
  PREFIX=%{_prefix} \
  SOPLEX_LINKOPTIONS="$RPM_LD_FLAGS"

# Build the manual
pushd doc
latex manual.tex
bibtex manual
latex manual.tex
latex manual.tex
dvipdf manual.dvi manual.pdf
popd

%install
make install PREFIX=%{buildroot}%{_prefix}
pushd %{buildroot}%{_bindir}
    ./%{name} installlinks
popd

%check
# The xfig test output varies slightly by architecture, and is non-critical,
# so we skip that test.
rm -fr testsuite/0009RenderStairCase
./gfan _test


%files
%doc README doc/manual.pdf
%doc --no-dereference COPYING LICENSE
%{_bindir}/*

%files          doc
%doc examples
%doc homepage

%changelog
